// Code generated by smithy-go-codegen DO NOT EDIT.

package storage

import (
	"bytes"
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/storage/types"
	"strings"
)

type awsRestxml_serializeOpAbortMultipartUpload struct {
}

func (*awsRestxml_serializeOpAbortMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpAbortMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AbortMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=AbortMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsAbortMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsAbortMultipartUploadInput(v *AbortMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpCompleteMultipartUpload struct {
}

func (*awsRestxml_serializeOpCompleteMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCompleteMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompleteMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=CompleteMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCompleteMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CompleteMultipartUpload != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CompleteMultipartUpload",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestCompleteMultipartUpload(input.CompleteMultipartUpload, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCompleteMultipartUploadInput(v *CompleteMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucket struct {
}

func (*awsRestxml_serializeOpDeleteBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=DeleteBucket")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketInput(v *DeleteBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketCors struct {
}

func (*awsRestxml_serializeOpDeleteBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors&x-id=DeleteBucketCors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketCorsInput(v *DeleteBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketLifecycle struct {
}

func (*awsRestxml_serializeOpDeleteBucketLifecycle) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketLifecycle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketLifecycleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle&x-id=DeleteBucketLifecycle")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleInput(v *DeleteBucketLifecycleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketPolicy struct {
}

func (*awsRestxml_serializeOpDeleteBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy&x-id=DeleteBucketPolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(v *DeleteBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketTagging struct {
}

func (*awsRestxml_serializeOpDeleteBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging&x-id=DeleteBucketTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(v *DeleteBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteMultipleObjects struct {
}

func (*awsRestxml_serializeOpDeleteMultipleObjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteMultipleObjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMultipleObjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?delete&x-id=DeleteMultipleObjects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteMultipleObjectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Delete != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Delete",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestDelete(input.Delete, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteMultipleObjectsInput(v *DeleteMultipleObjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	return nil
}

type awsRestxml_serializeOpDeleteObject struct {
}

func (*awsRestxml_serializeOpDeleteObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=DeleteObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteObjectInput(v *DeleteObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpDeleteObjectTagging struct {
}

func (*awsRestxml_serializeOpDeleteObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?tagging&x-id=DeleteObjectTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteObjectTaggingInput(v *DeleteObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetBucket struct {
}

func (*awsRestxml_serializeOpGetBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=GetBucket")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketInput(v *GetBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if v.EncodingType != nil {
		encoder.SetQuery("encoding-type").String(*v.EncodingType)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.MaxKeys != nil {
		encoder.SetQuery("max-keys").String(*v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketACL struct {
}

func (*awsRestxml_serializeOpGetBucketACL) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?acl&x-id=GetBucketACL")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketACLInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketACLInput(v *GetBucketACLInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketConsistency struct {
}

func (*awsRestxml_serializeOpGetBucketConsistency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketConsistency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketConsistencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-ntap-sg-consistency&x-id=GetBucketConsistency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketConsistencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketConsistencyInput(v *GetBucketConsistencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketCors struct {
}

func (*awsRestxml_serializeOpGetBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors&x-id=GetBucketCors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketCorsInput(v *GetBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle&x-id=GetBucketLifecycleConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(v *GetBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketObjectVersions struct {
}

func (*awsRestxml_serializeOpGetBucketObjectVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketObjectVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketObjectVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versions&x-id=GetBucketObjectVersions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketObjectVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketObjectVersionsInput(v *GetBucketObjectVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if v.EncodingType != nil {
		encoder.SetQuery("encoding-type").String(*v.EncodingType)
	}

	if v.KeyMarker != nil {
		encoder.SetQuery("key-marker").String(*v.KeyMarker)
	}

	if v.MaxKeys != nil {
		encoder.SetQuery("max-keys").String(*v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if v.VersionIdMarker != nil {
		encoder.SetQuery("version-id-marker").String(*v.VersionIdMarker)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketPolicy struct {
}

func (*awsRestxml_serializeOpGetBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy&x-id=GetBucketPolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(v *GetBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketTagging struct {
}

func (*awsRestxml_serializeOpGetBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging&x-id=GetBucketTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(v *GetBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketVersion2 struct {
}

func (*awsRestxml_serializeOpGetBucketVersion2) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketVersion2) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketVersion2Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=GetBucketVersion2")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketVersion2Input(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketVersion2Input(v *GetBucketVersion2Input, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if v.EncodingType != nil {
		encoder.SetQuery("encoding-type").String(*v.EncodingType)
	}

	if v.FetchOwner != nil {
		encoder.SetQuery("fetch-owner").String(*v.FetchOwner)
	}

	if v.ListType != nil {
		encoder.SetQuery("list-type").String(*v.ListType)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.MaxKeys != nil {
		encoder.SetQuery("max-keys").String(*v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if v.StartAfter != nil {
		encoder.SetQuery("start-after").String(*v.StartAfter)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketVersioning struct {
}

func (*awsRestxml_serializeOpGetBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versioning&x-id=GetBucketVersioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(v *GetBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetObject struct {
}

func (*awsRestxml_serializeOpGetObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=GetObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectInput(v *GetObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.PartNumber != nil {
		encoder.SetQuery("partNumber").String(*v.PartNumber)
	}

	if v.Range != nil && len(*v.Range) > 0 {
		locationName := "Range"
		encoder.SetHeader(locationName).String(*v.Range)
	}

	if v.ResponseContentDisposition != nil {
		encoder.SetQuery("response-content-disposition").String(*v.ResponseContentDisposition)
	}

	if v.ResponseContentEncoding != nil {
		encoder.SetQuery("response-content-encoding").String(*v.ResponseContentEncoding)
	}

	if v.ResponseContentType != nil {
		encoder.SetQuery("response-content-type").String(*v.ResponseContentType)
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectACL struct {
}

func (*awsRestxml_serializeOpGetObjectACL) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectACL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectACLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?acl&x-id=GetObjectACL")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectACLInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectACLInput(v *GetObjectACLInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectTagging struct {
}

func (*awsRestxml_serializeOpGetObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?tagging&x-id=GetObjectTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectTaggingInput(v *GetObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetService struct {
}

func (*awsRestxml_serializeOpGetService) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/?x-id=GetService")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetServiceInput(v *GetServiceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHeadBucket struct {
}

func (*awsRestxml_serializeOpHeadBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHeadBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HeadBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=HeadBucket")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "HEAD"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHeadBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHeadBucketInput(v *HeadBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpHeadObject struct {
}

func (*awsRestxml_serializeOpHeadObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHeadObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HeadObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=HeadObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "HEAD"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHeadObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHeadObjectInput(v *HeadObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ConsistencyControl != nil && len(*v.ConsistencyControl) > 0 {
		locationName := "Consistency-Control"
		encoder.SetHeader(locationName).String(*v.ConsistencyControl)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.PartNumber != nil {
		encoder.SetQuery("partNumber").String(*v.PartNumber)
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	return nil
}

type awsRestxml_serializeOpInitiateMultipartUpload struct {
}

func (*awsRestxml_serializeOpInitiateMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpInitiateMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InitiateMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?uploads&x-id=InitiateMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsInitiateMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsInitiateMultipartUploadInput(v *InitiateMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if v.ContentEncoding != nil && len(*v.ContentEncoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(*v.ContentEncoding)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.XAmzMeta != nil && len(*v.XAmzMeta) > 0 {
		locationName := "X-Amz-Meta-"
		encoder.SetHeader(locationName).String(*v.XAmzMeta)
	}

	if v.XAmzServerSideEncryption != nil && len(*v.XAmzServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryption)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	if len(v.XAmzStorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.XAmzStorageClass))
	}

	if len(v.XAmzTagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(string(v.XAmzTagging))
	}

	return nil
}

type awsRestxml_serializeOpListMultipartUploads struct {
}

func (*awsRestxml_serializeOpListMultipartUploads) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListMultipartUploads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultipartUploadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?uploads&x-id=ListMultipartUploads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListMultipartUploadsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListMultipartUploadsInput(v *ListMultipartUploadsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.EncodingType != nil && len(*v.EncodingType) > 0 {
		locationName := "Encoding-Type"
		encoder.SetHeader(locationName).String(*v.EncodingType)
	}

	if v.KeyMarker != nil && len(*v.KeyMarker) > 0 {
		locationName := "Key-Marker"
		encoder.SetHeader(locationName).String(*v.KeyMarker)
	}

	if v.MaxUploads != nil {
		locationName := "Max-Uploads"
		encoder.SetHeader(locationName).Integer(*v.MaxUploads)
	}

	if v.Prefix != nil && len(*v.Prefix) > 0 {
		locationName := "Prefix"
		encoder.SetHeader(locationName).String(*v.Prefix)
	}

	if v.UploadIdMarker != nil && len(*v.UploadIdMarker) > 0 {
		locationName := "Upload-Id-Marker"
		encoder.SetHeader(locationName).String(*v.UploadIdMarker)
	}

	return nil
}

type awsRestxml_serializeOpListParts struct {
}

func (*awsRestxml_serializeOpListParts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListParts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPartsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=ListParts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListPartsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListPartsInput(v *ListPartsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.EncodingType != nil {
		encoder.SetQuery("encoding-type").String(*v.EncodingType)
	}

	if v.MaxParts != nil {
		encoder.SetQuery("max-parts").String(*v.MaxParts)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.PartNumberMarker != nil {
		encoder.SetQuery("part-number-marker").String(*v.PartNumberMarker)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpPutBucket struct {
}

func (*awsRestxml_serializeOpPutBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=PutBucket")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketInput(v *PutBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpPutBucketConsistency struct {
}

func (*awsRestxml_serializeOpPutBucketConsistency) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketConsistency) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketConsistencyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?x-id=PutBucketConsistency")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketConsistencyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketConsistencyInput(v *PutBucketConsistencyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.XNtapSgConsistency) > 0 {
		encoder.SetQuery("x-ntap-sg-consistency").String(string(v.XNtapSgConsistency))
	}

	return nil
}

type awsRestxml_serializeOpPutBucketCors struct {
}

func (*awsRestxml_serializeOpPutBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors&x-id=PutBucketCors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CORSConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CORSConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestCORSConfiguration(input.CORSConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketCorsInput(v *PutBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpPutBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle&x-id=PutBucketLifecycleConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.LifecycleConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LifecycleConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestLifecycleConfiguration(input.LifecycleConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(v *PutBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpPutBucketPolicy struct {
}

func (*awsRestxml_serializeOpPutBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy&x-id=PutBucketPolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("text/plain")
	}

	if input.Policy != nil {
		payload := strings.NewReader(*input.Policy)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(v *PutBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketTagging struct {
}

func (*awsRestxml_serializeOpPutBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging&x-id=PutBucketTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tagging != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestTaggingOfPutBucketTagging(input.Tagging, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(v *PutBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketVersioning struct {
}

func (*awsRestxml_serializeOpPutBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versioning&x-id=PutBucketVersioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VersioningConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VersioningConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestVersioningConfiguration(input.VersioningConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(v *PutBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	return nil
}

type awsRestxml_serializeOpPutObject struct {
}

func (*awsRestxml_serializeOpPutObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=PutObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectInput(v *PutObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if len(v.ContentEncoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(string(v.ContentEncoding))
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.XAmzMeta != nil && len(*v.XAmzMeta) > 0 {
		locationName := "X-Amz-Meta-"
		encoder.SetHeader(locationName).String(*v.XAmzMeta)
	}

	if len(v.XAmzServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryption))
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	if len(v.XAmzStorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.XAmzStorageClass))
	}

	if v.XAmzTagging != nil && len(*v.XAmzTagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.XAmzTagging)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectCopy struct {
}

func (*awsRestxml_serializeOpPutObjectCopy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectCopy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectCopyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=PutObjectCopy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectCopyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectCopyInput(v *PutObjectCopyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.XAmzCopySource != nil && len(*v.XAmzCopySource) > 0 {
		locationName := "X-Amz-Copy-Source"
		encoder.SetHeader(locationName).String(*v.XAmzCopySource)
	}

	if v.XAmzCopySourceIfMatch != nil && len(*v.XAmzCopySourceIfMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-Match"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfMatch)
	}

	if v.XAmzCopySourceIfModifiedSince != nil && len(*v.XAmzCopySourceIfModifiedSince) > 0 {
		locationName := "X-Amz-Copy-Source-If-Modified-Since"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfModifiedSince)
	}

	if v.XAmzCopySourceIfNoneMatch != nil && len(*v.XAmzCopySourceIfNoneMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-None-Match"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfNoneMatch)
	}

	if v.XAmzCopySourceIfUnmodifiedSince != nil && len(*v.XAmzCopySourceIfUnmodifiedSince) > 0 {
		locationName := "X-Amz-Copy-Source-If-Unmodified-Since"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfUnmodifiedSince)
	}

	if len(v.XAmzCopySourceServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzCopySourceServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzCopySourceServerSideEncryptionCustomerKey != nil && len(*v.XAmzCopySourceServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceServerSideEncryptionCustomerKey)
	}

	if v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5)
	}

	if len(v.XAmzMetadataDirective) > 0 {
		locationName := "X-Amz-Metadata-Directive"
		encoder.SetHeader(locationName).String(string(v.XAmzMetadataDirective))
	}

	if v.XAmzServerSideEncryption != nil && len(*v.XAmzServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryption)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	if len(v.XAmzStorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.XAmzStorageClass))
	}

	if v.XAmzTagging != nil && len(*v.XAmzTagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.XAmzTagging)
	}

	if len(v.XAmzTaggingDirective) > 0 {
		locationName := "X-Amz-Tagging-Directive"
		encoder.SetHeader(locationName).String(string(v.XAmzTaggingDirective))
	}

	return nil
}

type awsRestxml_serializeOpPutObjectTagging struct {
}

func (*awsRestxml_serializeOpPutObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?tagging&x-id=PutObjectTagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tagging != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestTagging(input.Tagging, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectTaggingInput(v *PutObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpUploadPart struct {
}

func (*awsRestxml_serializeOpUploadPart) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUploadPart) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadPartInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=UploadPart")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUploadPartInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Body != nil {
		payload := bytes.NewReader(input.Body)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUploadPartInput(v *UploadPartInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMd5 != nil && len(*v.ContentMd5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMd5)
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.PartNumber != nil {
		encoder.SetQuery("partNumber").String(*v.PartNumber)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	return nil
}

type awsRestxml_serializeOpUploadPartCopy struct {
}

func (*awsRestxml_serializeOpUploadPartCopy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUploadPartCopy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadPartCopyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Object+}?x-id=UploadPartCopy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUploadPartCopyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUploadPartCopyInput(v *UploadPartCopyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Object == nil || len(*v.Object) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Object must not be empty")}
	}
	if v.Object != nil {
		if err := encoder.SetURI("Object").String(*v.Object); err != nil {
			return err
		}
	}

	if v.PartNumber != nil {
		encoder.SetQuery("partNumber").String(*v.PartNumber)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	if v.XAmzCopySource != nil && len(*v.XAmzCopySource) > 0 {
		locationName := "X-Amz-Copy-Source"
		encoder.SetHeader(locationName).String(*v.XAmzCopySource)
	}

	if v.XAmzCopySourceIfMatch != nil && len(*v.XAmzCopySourceIfMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-Match"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfMatch)
	}

	if v.XAmzCopySourceIfModifiedSince != nil && len(*v.XAmzCopySourceIfModifiedSince) > 0 {
		locationName := "X-Amz-Copy-Source-If-Modified-Since"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfModifiedSince)
	}

	if v.XAmzCopySourceIfNoneMatch != nil && len(*v.XAmzCopySourceIfNoneMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-None-Match"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfNoneMatch)
	}

	if v.XAmzCopySourceIfUnmodifiedSince != nil && len(*v.XAmzCopySourceIfUnmodifiedSince) > 0 {
		locationName := "X-Amz-Copy-Source-If-Unmodified-Since"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceIfUnmodifiedSince)
	}

	if v.XAmzCopySourceRange != nil && len(*v.XAmzCopySourceRange) > 0 {
		locationName := "X-Amz-Copy-Source-Range"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceRange)
	}

	if len(v.XAmzCopySourceServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzCopySourceServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzCopySourceServerSideEncryptionCustomerKey != nil && len(*v.XAmzCopySourceServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceServerSideEncryptionCustomerKey)
	}

	if v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzCopySourceServerSideEncryptionCustomerKeyMd5)
	}

	if len(v.XAmzServerSideEncryptionCustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(string(v.XAmzServerSideEncryptionCustomerAlgorithm))
	}

	if v.XAmzServerSideEncryptionCustomerKey != nil && len(*v.XAmzServerSideEncryptionCustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKey)
	}

	if v.XAmzServerSideEncryptionCustomerKeyMd5 != nil && len(*v.XAmzServerSideEncryptionCustomerKeyMd5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.XAmzServerSideEncryptionCustomerKeyMd5)
	}

	return nil
}

func awsRestxml_serializeDocumentListOfRequestAllowedMethod(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestCORSRule(v []types.RequestCORSRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestCORSRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestObject(v []types.RequestObject, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestObject(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestPart(v []types.RequestPart, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestPart(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestRule(v []types.RequestRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestTag(v []types.RequestTag, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestTag(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentListOfRequestTagSet(v []types.RequestTagSet, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRequestTagSet(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestAnd(v *types.RequestAnd, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestTag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestTag(v.ListOfRequestTag, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestCompleteMultipartUpload(v *types.RequestCompleteMultipartUpload, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestPart != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Part",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestPart(v.ListOfRequestPart, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestCORSConfiguration(v *types.RequestCORSConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestCORSRule != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CORSRule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestCORSRule(v.ListOfRequestCORSRule, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestCORSRule(v *types.RequestCORSRule, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowedHeader != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedHeader",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.AllowedHeader)
	}
	if v.AllowedOrigin != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedOrigin",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.AllowedOrigin)
	}
	if v.ExposeHeader != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExposeHeader",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ExposeHeader)
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.ListOfRequestAllowedMethod != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedMethod",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestAllowedMethod(v.ListOfRequestAllowedMethod, el); err != nil {
			return err
		}
	}
	if v.MaxAgeSeconds != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxAgeSeconds",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.MaxAgeSeconds)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestDelete(v *types.RequestDelete, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestObject != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Object",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestObject(v.ListOfRequestObject, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestExpiration(v *types.RequestExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.Date != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Date",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Date))
	}
	if v.Days != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Days)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestFilter(v *types.RequestFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.RequestAnd != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestAnd(v.RequestAnd, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestLifecycleConfiguration(v *types.RequestLifecycleConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestRule != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestRule(v.ListOfRequestRule, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestNoncurrentVersionExpiration(v *types.RequestNoncurrentVersionExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.NoncurrentDays != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.NoncurrentDays)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestObject(v *types.RequestObject, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Quiet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quiet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.Quiet)
	}
	if v.VersionId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VersionId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.VersionId)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestPart(v *types.RequestPart, value smithyxml.Value) error {
	defer value.Close()
	if v.ETag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ETag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ETag)
	}
	if v.PartNumber != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PartNumber",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.PartNumber)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestRule(v *types.RequestRule, value smithyxml.Value) error {
	defer value.Close()
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.RequestExpiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Expiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestExpiration(v.RequestExpiration, el); err != nil {
			return err
		}
	}
	if v.RequestFilter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestFilter(v.RequestFilter, el); err != nil {
			return err
		}
	}
	if v.RequestNoncurrentVersionExpiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentVersionExpiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestNoncurrentVersionExpiration(v.RequestNoncurrentVersionExpiration, el); err != nil {
			return err
		}
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentRequestTag(v *types.RequestTag, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestTagging(v *types.RequestTagging, value smithyxml.Value) error {
	defer value.Close()
	if v.RequestTagSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestTagSet(v.RequestTagSet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestTaggingOfPutBucketTagging(v *types.RequestTaggingOfPutBucketTagging, value smithyxml.Value) error {
	defer value.Close()
	if v.ListOfRequestTagSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagSet",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListOfRequestTagSet(v.ListOfRequestTagSet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestTagSet(v *types.RequestTagSet, value smithyxml.Value) error {
	defer value.Close()
	if v.RequestTag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestTag(v.RequestTag, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRequestVersioningConfiguration(v *types.RequestVersioningConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}
