// Code generated by smithy-go-codegen DO NOT EDIT.

package rdb

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/rdb/types"
)

func (c *Client) RestoreDBInstanceFromDBSnapshot(ctx context.Context, params *RestoreDBInstanceFromDBSnapshotInput, optFns ...func(*Options)) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	if params == nil {
		params = &RestoreDBInstanceFromDBSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RestoreDBInstanceFromDBSnapshot", params, optFns, c.addOperationRestoreDBInstanceFromDBSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RestoreDBInstanceFromDBSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RestoreDBInstanceFromDBSnapshotInput struct {

	// This member is required.
	DBInstanceClass types.DBInstanceClassOfRestoreDBInstanceFromDBSnapshotRequest

	// This member is required.
	DBInstanceIdentifier *string

	// This member is required.
	DBSnapshotIdentifier *string

	AccountingType types.AccountingTypeOfRestoreDBInstanceFromDBSnapshotRequest

	AutoMinorVersionUpgrade *bool

	AvailabilityZone *string

	DBName *string

	DBSubnetGroupName *string

	DowngradeRestore *bool

	Engine *string

	Iops *int32

	LicenseModel *string

	MultiAZ *bool

	NiftyDBParameterGroupName *string

	NiftyDBSecurityGroups []string

	NiftyMasterPrivateAddress *string

	NiftyNetworkId *string

	NiftySlavePrivateAddress *string

	NiftyStorageType *int32

	NiftyVirtualPrivateAddress *string

	OptionGroupName *string

	Port *int32

	PubliclyAccessible *bool

	noSmithyDocumentSerde
}

type RestoreDBInstanceFromDBSnapshotOutput struct {
	DBInstance *types.DBInstance

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRestoreDBInstanceFromDBSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpRestoreDBInstanceFromDBSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpRestoreDBInstanceFromDBSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRestoreDBInstanceFromDBSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRestoreDBInstanceFromDBSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRestoreDBInstanceFromDBSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rdb",
		OperationName: "RestoreDBInstanceFromDBSnapshot",
	}
}
