// Code generated by smithy-go-codegen DO NOT EDIT.

package rdb

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"github.com/nifcloud/nifcloud-sdk-go/service/rdb/types"
	"strconv"
	"time"
)

func (c *Client) DescribeDBSecurityGroups(ctx context.Context, params *DescribeDBSecurityGroupsInput, optFns ...func(*Options)) (*DescribeDBSecurityGroupsOutput, error) {
	if params == nil {
		params = &DescribeDBSecurityGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDBSecurityGroups", params, optFns, c.addOperationDescribeDBSecurityGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDBSecurityGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeDBSecurityGroupsInput struct {
	DBSecurityGroupName *string

	Filter *string

	FilterName *string

	FilterValue *string

	Filters []string

	Marker *string

	MaxRecords *int32

	noSmithyDocumentSerde
}

type DescribeDBSecurityGroupsOutput struct {
	DBSecurityGroups []types.DBSecurityGroupsOfDescribeDBSecurityGroups

	Marker *string

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDBSecurityGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeDBSecurityGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeDBSecurityGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDBSecurityGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeDBSecurityGroupsAPIClient is a client that implements the
// DescribeDBSecurityGroups operation.
type DescribeDBSecurityGroupsAPIClient interface {
	DescribeDBSecurityGroups(context.Context, *DescribeDBSecurityGroupsInput, ...func(*Options)) (*DescribeDBSecurityGroupsOutput, error)
}

var _ DescribeDBSecurityGroupsAPIClient = (*Client)(nil)

// DBSecurityGroupExistsWaiterOptions are waiter options for
// DBSecurityGroupExistsWaiter
type DBSecurityGroupExistsWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupExistsWaiter will use default minimum delay of 20 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupExistsWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupExistsWaiter defines the waiters for DBSecurityGroupExists
type DBSecurityGroupExistsWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupExistsWaiterOptions
}

// NewDBSecurityGroupExistsWaiter constructs a DBSecurityGroupExistsWaiter.
func NewDBSecurityGroupExistsWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupExistsWaiterOptions)) *DBSecurityGroupExistsWaiter {
	options := DBSecurityGroupExistsWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupExistsStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupExistsWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupExists waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *DBSecurityGroupExistsWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupExistsWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupExists waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *DBSecurityGroupExistsWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupExistsWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupExists waiter")
}

func dBSecurityGroupExistsStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(DBSecurityGroups[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.DBSecurityGroup" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions are waiter options for
// DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter
type DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter will use default minimum delay
	// of 20 seconds. Note that MinDelay must resolve to a value lesser than or equal
	// to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter will use default
	// max delay of 120 seconds. Note that MaxDelay must resolve to value greater than
	// or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter defines the waiters for
// DBSecurityGroupEC2SecurityGroupsAuthorized
type DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions
}

// NewDBSecurityGroupEC2SecurityGroupsAuthorizedWaiter constructs a
// DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter.
func NewDBSecurityGroupEC2SecurityGroupsAuthorizedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions)) *DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter {
	options := DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupEC2SecurityGroupsAuthorizedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupEC2SecurityGroupsAuthorized
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// DBSecurityGroupEC2SecurityGroupsAuthorized waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsAuthorizedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthorizedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupEC2SecurityGroupsAuthorized waiter")
}

func dBSecurityGroupEC2SecurityGroupsAuthorizedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].EC2SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "authorized"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions are waiter options for
// DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter
type DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter will use default minimum delay
	// of 20 seconds. Note that MinDelay must resolve to a value lesser than or equal
	// to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter will use default
	// max delay of 120 seconds. Note that MaxDelay must resolve to value greater than
	// or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter defines the waiters for
// DBSecurityGroupEC2SecurityGroupsAuthFailed
type DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions
}

// NewDBSecurityGroupEC2SecurityGroupsAuthFailedWaiter constructs a
// DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter.
func NewDBSecurityGroupEC2SecurityGroupsAuthFailedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions)) *DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter {
	options := DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupEC2SecurityGroupsAuthFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupEC2SecurityGroupsAuthFailed
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// DBSecurityGroupEC2SecurityGroupsAuthFailed waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsAuthFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsAuthFailedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupEC2SecurityGroupsAuthFailed waiter")
}

func dBSecurityGroupEC2SecurityGroupsAuthFailedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].EC2SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "auth-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions are waiter options
// for DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter
type DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter will use default minimum
	// delay of 20 seconds. Note that MinDelay must resolve to a value lesser than or
	// equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter will use default
	// max delay of 120 seconds. Note that MaxDelay must resolve to value greater than
	// or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter defines the waiters for
// DBSecurityGroupEC2SecurityGroupsRevokeFailed
type DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions
}

// NewDBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter constructs a
// DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter.
func NewDBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions)) *DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter {
	options := DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupEC2SecurityGroupsRevokeFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupEC2SecurityGroupsRevokeFailed
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// DBSecurityGroupEC2SecurityGroupsRevokeFailed waiter and returns the output of
// the successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsRevokeFailedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupEC2SecurityGroupsRevokeFailed waiter")
}

func dBSecurityGroupEC2SecurityGroupsRevokeFailedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].EC2SecurityGroups[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "revoke-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions are waiter options for
// DBSecurityGroupEC2SecurityGroupsEmptiedWaiter
type DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupEC2SecurityGroupsEmptiedWaiter will use default minimum delay of
	// 20 seconds. Note that MinDelay must resolve to a value lesser than or equal to
	// the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupEC2SecurityGroupsEmptiedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupEC2SecurityGroupsEmptiedWaiter defines the waiters for
// DBSecurityGroupEC2SecurityGroupsEmptied
type DBSecurityGroupEC2SecurityGroupsEmptiedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions
}

// NewDBSecurityGroupEC2SecurityGroupsEmptiedWaiter constructs a
// DBSecurityGroupEC2SecurityGroupsEmptiedWaiter.
func NewDBSecurityGroupEC2SecurityGroupsEmptiedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions)) *DBSecurityGroupEC2SecurityGroupsEmptiedWaiter {
	options := DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupEC2SecurityGroupsEmptiedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupEC2SecurityGroupsEmptiedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupEC2SecurityGroupsEmptied
// waiter. The maxWaitDur is the maximum wait duration the waiter will wait. The
// maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsEmptiedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for
// DBSecurityGroupEC2SecurityGroupsEmptied waiter and returns the output of the
// successful operation. The maxWaitDur is the maximum wait duration the waiter
// will wait. The maxWaitDur is required and must be greater than zero.
func (w *DBSecurityGroupEC2SecurityGroupsEmptiedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupEC2SecurityGroupsEmptiedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupEC2SecurityGroupsEmptied waiter")
}

func dBSecurityGroupEC2SecurityGroupsEmptiedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(DBSecurityGroups[0].EC2SecurityGroups[]) == `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupIPRangesAuthorizedWaiterOptions are waiter options for
// DBSecurityGroupIPRangesAuthorizedWaiter
type DBSecurityGroupIPRangesAuthorizedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupIPRangesAuthorizedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupIPRangesAuthorizedWaiter will use default max delay
	// of 120 seconds. Note that MaxDelay must resolve to value greater than or equal
	// to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupIPRangesAuthorizedWaiter defines the waiters for
// DBSecurityGroupIPRangesAuthorized
type DBSecurityGroupIPRangesAuthorizedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupIPRangesAuthorizedWaiterOptions
}

// NewDBSecurityGroupIPRangesAuthorizedWaiter constructs a
// DBSecurityGroupIPRangesAuthorizedWaiter.
func NewDBSecurityGroupIPRangesAuthorizedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupIPRangesAuthorizedWaiterOptions)) *DBSecurityGroupIPRangesAuthorizedWaiter {
	options := DBSecurityGroupIPRangesAuthorizedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupIPRangesAuthorizedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupIPRangesAuthorizedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupIPRangesAuthorized waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *DBSecurityGroupIPRangesAuthorizedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesAuthorizedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupIPRangesAuthorized
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *DBSecurityGroupIPRangesAuthorizedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesAuthorizedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupIPRangesAuthorized waiter")
}

func dBSecurityGroupIPRangesAuthorizedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "authorized"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupIPRangesAuthFailedWaiterOptions are waiter options for
// DBSecurityGroupIPRangesAuthFailedWaiter
type DBSecurityGroupIPRangesAuthFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupIPRangesAuthFailedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupIPRangesAuthFailedWaiter will use default max delay
	// of 120 seconds. Note that MaxDelay must resolve to value greater than or equal
	// to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupIPRangesAuthFailedWaiter defines the waiters for
// DBSecurityGroupIPRangesAuthFailed
type DBSecurityGroupIPRangesAuthFailedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupIPRangesAuthFailedWaiterOptions
}

// NewDBSecurityGroupIPRangesAuthFailedWaiter constructs a
// DBSecurityGroupIPRangesAuthFailedWaiter.
func NewDBSecurityGroupIPRangesAuthFailedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupIPRangesAuthFailedWaiterOptions)) *DBSecurityGroupIPRangesAuthFailedWaiter {
	options := DBSecurityGroupIPRangesAuthFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupIPRangesAuthFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupIPRangesAuthFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupIPRangesAuthFailed waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *DBSecurityGroupIPRangesAuthFailedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesAuthFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupIPRangesAuthFailed
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *DBSecurityGroupIPRangesAuthFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesAuthFailedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupIPRangesAuthFailed waiter")
}

func dBSecurityGroupIPRangesAuthFailedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "auth-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupIPRangesRevokeFailedWaiterOptions are waiter options for
// DBSecurityGroupIPRangesRevokeFailedWaiter
type DBSecurityGroupIPRangesRevokeFailedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupIPRangesRevokeFailedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupIPRangesRevokeFailedWaiter will use default max
	// delay of 120 seconds. Note that MaxDelay must resolve to value greater than or
	// equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupIPRangesRevokeFailedWaiter defines the waiters for
// DBSecurityGroupIPRangesRevokeFailed
type DBSecurityGroupIPRangesRevokeFailedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupIPRangesRevokeFailedWaiterOptions
}

// NewDBSecurityGroupIPRangesRevokeFailedWaiter constructs a
// DBSecurityGroupIPRangesRevokeFailedWaiter.
func NewDBSecurityGroupIPRangesRevokeFailedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupIPRangesRevokeFailedWaiterOptions)) *DBSecurityGroupIPRangesRevokeFailedWaiter {
	options := DBSecurityGroupIPRangesRevokeFailedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupIPRangesRevokeFailedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupIPRangesRevokeFailedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupIPRangesRevokeFailed waiter.
// The maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur
// is required and must be greater than zero.
func (w *DBSecurityGroupIPRangesRevokeFailedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesRevokeFailedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupIPRangesRevokeFailed
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *DBSecurityGroupIPRangesRevokeFailedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesRevokeFailedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupIPRangesRevokeFailed waiter")
}

func dBSecurityGroupIPRangesRevokeFailedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("DBSecurityGroups[].IPRanges[].Status", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "revoke-failed"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupIPRangesEmptiedWaiterOptions are waiter options for
// DBSecurityGroupIPRangesEmptiedWaiter
type DBSecurityGroupIPRangesEmptiedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupIPRangesEmptiedWaiter will use default minimum delay of 20
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupIPRangesEmptiedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupIPRangesEmptiedWaiter defines the waiters for
// DBSecurityGroupIPRangesEmptied
type DBSecurityGroupIPRangesEmptiedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupIPRangesEmptiedWaiterOptions
}

// NewDBSecurityGroupIPRangesEmptiedWaiter constructs a
// DBSecurityGroupIPRangesEmptiedWaiter.
func NewDBSecurityGroupIPRangesEmptiedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupIPRangesEmptiedWaiterOptions)) *DBSecurityGroupIPRangesEmptiedWaiter {
	options := DBSecurityGroupIPRangesEmptiedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupIPRangesEmptiedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupIPRangesEmptiedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupIPRangesEmptied waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *DBSecurityGroupIPRangesEmptiedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesEmptiedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupIPRangesEmptied
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *DBSecurityGroupIPRangesEmptiedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupIPRangesEmptiedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupIPRangesEmptied waiter")
}

func dBSecurityGroupIPRangesEmptiedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(DBSecurityGroups[0].IPRanges[]) == `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	return true, nil
}

// DBSecurityGroupDeletedWaiterOptions are waiter options for
// DBSecurityGroupDeletedWaiter
type DBSecurityGroupDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// DBSecurityGroupDeletedWaiter will use default minimum delay of 20 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, DBSecurityGroupDeletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeDBSecurityGroupsInput, *DescribeDBSecurityGroupsOutput, error) (bool, error)
}

// DBSecurityGroupDeletedWaiter defines the waiters for DBSecurityGroupDeleted
type DBSecurityGroupDeletedWaiter struct {
	client DescribeDBSecurityGroupsAPIClient

	options DBSecurityGroupDeletedWaiterOptions
}

// NewDBSecurityGroupDeletedWaiter constructs a DBSecurityGroupDeletedWaiter.
func NewDBSecurityGroupDeletedWaiter(client DescribeDBSecurityGroupsAPIClient, optFns ...func(*DBSecurityGroupDeletedWaiterOptions)) *DBSecurityGroupDeletedWaiter {
	options := DBSecurityGroupDeletedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = dBSecurityGroupDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &DBSecurityGroupDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for DBSecurityGroupDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *DBSecurityGroupDeletedWaiter) Wait(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for DBSecurityGroupDeleted waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *DBSecurityGroupDeletedWaiter) WaitForOutput(ctx context.Context, params *DescribeDBSecurityGroupsInput, maxWaitDur time.Duration, optFns ...func(*DBSecurityGroupDeletedWaiterOptions)) (*DescribeDBSecurityGroupsOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeDBSecurityGroups(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for DBSecurityGroupDeleted waiter")
}

func dBSecurityGroupDeletedStateRetryable(ctx context.Context, input *DescribeDBSecurityGroupsInput, output *DescribeDBSecurityGroupsOutput, err error) (bool, error) {

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.DBSecurityGroup" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("length(DBSecurityGroups[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return true, nil
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opDescribeDBSecurityGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rdb",
		OperationName: "DescribeDBSecurityGroups",
	}
}
