// Code generated by smithy-go-codegen DO NOT EDIT.

package nas

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/nas/types"
)

func (c *Client) CreateNASInstance(ctx context.Context, params *CreateNASInstanceInput, optFns ...func(*Options)) (*CreateNASInstanceOutput, error) {
	if params == nil {
		params = &CreateNASInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateNASInstance", params, optFns, c.addOperationCreateNASInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateNASInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateNASInstanceInput struct {

	// This member is required.
	AllocatedStorage *int32

	// This member is required.
	NASInstanceIdentifier *string

	// This member is required.
	Protocol types.ProtocolOfCreateNASInstanceRequest

	AvailabilityZone *string

	MasterPrivateAddress *string

	MasterUserPassword *string

	MasterUsername *string

	NASInstanceDescription *string

	NASInstanceType *int32

	NASSecurityGroups []string

	NetworkId *string

	noSmithyDocumentSerde
}

type CreateNASInstanceOutput struct {
	NASInstance *types.NASInstance

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateNASInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateNASInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateNASInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateNASInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateNASInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateNASInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "nas",
		OperationName: "CreateNASInstance",
	}
}
