// Code generated by smithy-go-codegen DO NOT EDIT.

package ess

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/internal/serializers"
	"github.com/nifcloud/nifcloud-sdk-go/service/ess/types"
	"path"
	"reflect"
)

type awsAwsquery_serializeOpDeleteIdentity struct {
}

func (*awsAwsquery_serializeOpDeleteIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteIdentity")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentDeleteIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetDeliveryLog struct {
}

func (*awsAwsquery_serializeOpGetDeliveryLog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetDeliveryLog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeliveryLogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetDeliveryLog")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentGetDeliveryLogInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityDkimAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityDkimAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityDkimAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityDkimAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityDkimAttributes")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentGetIdentityDkimAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetIdentityVerificationAttributes struct {
}

func (*awsAwsquery_serializeOpGetIdentityVerificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetIdentityVerificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityVerificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetIdentityVerificationAttributes")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentGetIdentityVerificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetSendQuota struct {
}

func (*awsAwsquery_serializeOpGetSendQuota) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetSendQuota) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSendQuotaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetSendQuota")
	body.Key("Version").String("2010-12-01N2014-05-28")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetSendStatistics struct {
}

func (*awsAwsquery_serializeOpGetSendStatistics) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetSendStatistics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSendStatisticsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetSendStatistics")
	body.Key("Version").String("2010-12-01N2014-05-28")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListIdentities struct {
}

func (*awsAwsquery_serializeOpListIdentities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListIdentities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListIdentities")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentListIdentitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendEmail struct {
}

func (*awsAwsquery_serializeOpSendEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendEmail")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentSendEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendRawEmail struct {
}

func (*awsAwsquery_serializeOpSendRawEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendRawEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendRawEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendRawEmail")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentSendRawEmailInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetIdentityDkimEnabled struct {
}

func (*awsAwsquery_serializeOpSetIdentityDkimEnabled) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetIdentityDkimEnabled) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityDkimEnabledInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetIdentityDkimEnabled")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentSetIdentityDkimEnabledInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyDomainDkim struct {
}

func (*awsAwsquery_serializeOpVerifyDomainDkim) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyDomainDkim) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyDomainDkimInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyDomainDkim")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentVerifyDomainDkimInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyDomainIdentity struct {
}

func (*awsAwsquery_serializeOpVerifyDomainIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyDomainIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyDomainIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyDomainIdentity")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentVerifyDomainIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpVerifyEmailIdentity struct {
}

func (*awsAwsquery_serializeOpVerifyEmailIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpVerifyEmailIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyEmailIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("VerifyEmailIdentity")
	body.Key("Version").String("2010-12-01N2014-05-28")

	if err := awsAwsquery_serializeOpDocumentVerifyEmailIdentityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentListOfRequestBccAddresses(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfRequestCcAddresses(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfRequestDestinations(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfRequestIdentities(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfRequestReplyToAddresses(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentListOfRequestToAddresses(v []string, value query.Value) error {
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentRequestBody(v *types.RequestBody, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestHtml != nil {
		objectKey := object.Key("Html")
		if err := awsAwsquery_serializeDocumentRequestHtml(v.RequestHtml, objectKey); err != nil {
			return err
		}
	}

	if v.RequestText != nil {
		objectKey := object.Key("Text")
		if err := awsAwsquery_serializeDocumentRequestText(v.RequestText, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestDestination(v *types.RequestDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestBccAddresses != nil {
		objectKey := object.Key("BccAddresses")
		if err := awsAwsquery_serializeDocumentListOfRequestBccAddresses(v.ListOfRequestBccAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestCcAddresses != nil {
		objectKey := object.Key("CcAddresses")
		if err := awsAwsquery_serializeDocumentListOfRequestCcAddresses(v.ListOfRequestCcAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestToAddresses != nil {
		objectKey := object.Key("ToAddresses")
		if err := awsAwsquery_serializeDocumentListOfRequestToAddresses(v.ListOfRequestToAddresses, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestHtml(v *types.RequestHtml, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Charset != nil {
		objectKey := object.Key("Charset")
		objectKey.String(*v.Charset)
	}

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.String(*v.Data)
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestMessage(v *types.RequestMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestBody != nil {
		objectKey := object.Key("Body")
		if err := awsAwsquery_serializeDocumentRequestBody(v.RequestBody, objectKey); err != nil {
			return err
		}
	}

	if v.RequestSubject != nil {
		objectKey := object.Key("Subject")
		if err := awsAwsquery_serializeDocumentRequestSubject(v.RequestSubject, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestRawMessage(v *types.RequestRawMessage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.String(*v.Data)
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestSubject(v *types.RequestSubject, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Charset != nil {
		objectKey := object.Key("Charset")
		objectKey.String(*v.Charset)
	}

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.String(*v.Data)
	}

	return nil
}

func awsAwsquery_serializeDocumentRequestText(v *types.RequestText, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Charset != nil {
		objectKey := object.Key("Charset")
		objectKey.String(*v.Charset)
	}

	if v.Data != nil {
		objectKey := object.Key("Data")
		objectKey.String(*v.Data)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteIdentityInput(v *DeleteIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetDeliveryLogInput(v *GetDeliveryLogInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndDate != nil {
		objectKey := object.Key("EndDate")
		objectKey.String(serializers.FormatGetDeliveryLogDateTime(reflect.ValueOf(*v).Type().Name(), *v.EndDate))
	}

	if v.MaxItems != nil {
		objectKey := object.Key("MaxItems")
		objectKey.Integer(*v.MaxItems)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.StartDate != nil {
		objectKey := object.Key("StartDate")
		objectKey.String(serializers.FormatGetDeliveryLogDateTime(reflect.ValueOf(*v).Type().Name(), *v.StartDate))
	}

	if v.Status != nil {
		objectKey := object.Key("Status")
		objectKey.Integer(*v.Status)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityDkimAttributesInput(v *GetIdentityDkimAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentListOfRequestIdentities(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetIdentityVerificationAttributesInput(v *GetIdentityVerificationAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Identities != nil {
		objectKey := object.Key("Identities")
		if err := awsAwsquery_serializeDocumentListOfRequestIdentities(v.Identities, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetSendQuotaInput(v *GetSendQuotaInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsAwsquery_serializeOpDocumentGetSendStatisticsInput(v *GetSendStatisticsInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsAwsquery_serializeOpDocumentListIdentitiesInput(v *ListIdentitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.IdentityType) > 0 {
		objectKey := object.Key("IdentityType")
		objectKey.String(string(v.IdentityType))
	}

	if v.MaxItems != nil {
		objectKey := object.Key("MaxItems")
		objectKey.Integer(*v.MaxItems)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendEmailInput(v *SendEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsAwsquery_serializeDocumentRequestDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.Message != nil {
		objectKey := object.Key("Message")
		if err := awsAwsquery_serializeDocumentRequestMessage(v.Message, objectKey); err != nil {
			return err
		}
	}

	if v.ReplyToAddresses != nil {
		objectKey := object.Key("ReplyToAddresses")
		if err := awsAwsquery_serializeDocumentListOfRequestReplyToAddresses(v.ReplyToAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.ReturnPath != nil {
		objectKey := object.Key("ReturnPath")
		objectKey.String(*v.ReturnPath)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendRawEmailInput(v *SendRawEmailInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Destinations != nil {
		objectKey := object.Key("Destinations")
		if err := awsAwsquery_serializeDocumentListOfRequestDestinations(v.Destinations, objectKey); err != nil {
			return err
		}
	}

	if v.RawMessage != nil {
		objectKey := object.Key("RawMessage")
		if err := awsAwsquery_serializeDocumentRequestRawMessage(v.RawMessage, objectKey); err != nil {
			return err
		}
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		objectKey.String(*v.Source)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetIdentityDkimEnabledInput(v *SetIdentityDkimEnabledInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.DkimEnabled) > 0 {
		objectKey := object.Key("DkimEnabled")
		objectKey.String(string(v.DkimEnabled))
	}

	if v.Identity != nil {
		objectKey := object.Key("Identity")
		objectKey.String(*v.Identity)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyDomainDkimInput(v *VerifyDomainDkimInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Domain != nil {
		objectKey := object.Key("Domain")
		objectKey.String(*v.Domain)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyDomainIdentityInput(v *VerifyDomainIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Domain != nil {
		objectKey := object.Key("Domain")
		objectKey.String(*v.Domain)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentVerifyEmailIdentityInput(v *VerifyEmailIdentityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	return nil
}
