// Code generated by smithy-go-codegen DO NOT EDIT.

package dns

import (
	"bytes"
	"context"
	"encoding/xml"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	awsxml "github.com/aws/aws-sdk-go-v2/aws/protocol/xml"
	smithy "github.com/aws/smithy-go"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/dns/types"
	"io"
	"strconv"
	"strings"
)

type awsRestxml_deserializeOpChangeResourceRecordSets struct {
}

func (*awsRestxml_deserializeOpChangeResourceRecordSets) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpChangeResourceRecordSets) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorChangeResourceRecordSets(response, &metadata)
	}
	output := &ChangeResourceRecordSetsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentChangeResourceRecordSetsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorChangeResourceRecordSets(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentChangeResourceRecordSetsOutput(v **ChangeResourceRecordSetsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ChangeResourceRecordSetsOutput
	if *v == nil {
		sv = &ChangeResourceRecordSetsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ChangeInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentChangeInfo(&sv.ChangeInfo, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpCreateHostedZone struct {
}

func (*awsRestxml_deserializeOpCreateHostedZone) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpCreateHostedZone) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorCreateHostedZone(response, &metadata)
	}
	output := &CreateHostedZoneOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentCreateHostedZoneOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorCreateHostedZone(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentCreateHostedZoneOutput(v **CreateHostedZoneOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateHostedZoneOutput
	if *v == nil {
		sv = &CreateHostedZoneOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ChangeInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentChangeInfo(&sv.ChangeInfo, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("DelegationSet", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentDelegationSet(&sv.DelegationSet, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("HostedZone", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentHostedZone(&sv.HostedZone, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpDeleteHostedZone struct {
}

func (*awsRestxml_deserializeOpDeleteHostedZone) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpDeleteHostedZone) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorDeleteHostedZone(response, &metadata)
	}
	output := &DeleteHostedZoneOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentDeleteHostedZoneOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorDeleteHostedZone(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentDeleteHostedZoneOutput(v **DeleteHostedZoneOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteHostedZoneOutput
	if *v == nil {
		sv = &DeleteHostedZoneOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ChangeInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentChangeInfo(&sv.ChangeInfo, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpGetChange struct {
}

func (*awsRestxml_deserializeOpGetChange) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpGetChange) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorGetChange(response, &metadata)
	}
	output := &GetChangeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentGetChangeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorGetChange(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentGetChangeOutput(v **GetChangeOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetChangeOutput
	if *v == nil {
		sv = &GetChangeOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ChangeInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentChangeInfo(&sv.ChangeInfo, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpGetHostedZone struct {
}

func (*awsRestxml_deserializeOpGetHostedZone) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpGetHostedZone) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorGetHostedZone(response, &metadata)
	}
	output := &GetHostedZoneOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentGetHostedZoneOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorGetHostedZone(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentGetHostedZoneOutput(v **GetHostedZoneOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *GetHostedZoneOutput
	if *v == nil {
		sv = &GetHostedZoneOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DelegationSet", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentDelegationSet(&sv.DelegationSet, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("HostedZone", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentHostedZone(&sv.HostedZone, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpListHostedZones struct {
}

func (*awsRestxml_deserializeOpListHostedZones) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpListHostedZones) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorListHostedZones(response, &metadata)
	}
	output := &ListHostedZonesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentListHostedZonesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorListHostedZones(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentListHostedZonesOutput(v **ListHostedZonesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListHostedZonesOutput
	if *v == nil {
		sv = &ListHostedZonesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("HostedZones", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentListOfHostedZones(&sv.HostedZones, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IsTruncated", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsTruncated = ptr.Bool(xtv)
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("MaxItems", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.MaxItems = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("NextMarker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextMarker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

type awsRestxml_deserializeOpListResourceRecordSets struct {
}

func (*awsRestxml_deserializeOpListResourceRecordSets) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestxml_deserializeOpListResourceRecordSets) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestxml_deserializeOpErrorListResourceRecordSets(response, &metadata)
	}
	output := &ListResourceRecordSetsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	err = awsRestxml_deserializeOpDocumentListResourceRecordSetsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestxml_deserializeOpErrorListResourceRecordSets(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestxml_deserializeOpDocumentListResourceRecordSetsOutput(v **ListResourceRecordSetsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListResourceRecordSetsOutput
	if *v == nil {
		sv = &ListResourceRecordSetsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("IsTruncated", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsTruncated = ptr.Bool(xtv)
			}

		case strings.EqualFold("MaxItems", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.MaxItems = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("NextRecordIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextRecordIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("NextRecordName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextRecordName = ptr.String(xtv)
			}

		case strings.EqualFold("NextRecordType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextRecordType = ptr.String(xtv)
			}

		case strings.EqualFold("ResourceRecordSets", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentListOfResourceRecordSets(&sv.ResourceRecordSets, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentChangeInfo(v **types.ChangeInfo, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ChangeInfo
	if *v == nil {
		sv = &types.ChangeInfo{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Id", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Id = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("SubmittedAt", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubmittedAt = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentConfig(v **types.Config, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Config
	if *v == nil {
		sv = &types.Config{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Comment", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Comment = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentDelegationSet(v **types.DelegationSet, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DelegationSet
	if *v == nil {
		sv = &types.DelegationSet{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NameServers", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentListOfNameServers(&sv.NameServers, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentHostedZone(v **types.HostedZone, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HostedZone
	if *v == nil {
		sv = &types.HostedZone{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CallerReference", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CallerReference = ptr.String(xtv)
			}

		case strings.EqualFold("Config", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentConfig(&sv.Config, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Id", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Id = ptr.String(xtv)
			}

		case strings.EqualFold("Name", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Name = ptr.String(xtv)
			}

		case strings.EqualFold("ResourceRecordSetCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ResourceRecordSetCount = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentHostedZones(v **types.HostedZones, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HostedZones
	if *v == nil {
		sv = &types.HostedZones{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CallerReference", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CallerReference = ptr.String(xtv)
			}

		case strings.EqualFold("Config", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentConfig(&sv.Config, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Id", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Id = ptr.String(xtv)
			}

		case strings.EqualFold("Name", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Name = ptr.String(xtv)
			}

		case strings.EqualFold("ResourceRecordSetCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ResourceRecordSetCount = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentListOfHostedZones(v *[]types.HostedZones, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.HostedZones
	if *v == nil {
		sv = make([]types.HostedZones, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("HostedZone", t.Name.Local):
			var col types.HostedZones
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsRestxml_deserializeDocumentHostedZones(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentListOfHostedZonesUnwrapped(v *[]types.HostedZones, decoder smithyxml.NodeDecoder) error {
	var sv []types.HostedZones
	if *v == nil {
		sv = make([]types.HostedZones, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.HostedZones
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsRestxml_deserializeDocumentHostedZones(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsRestxml_deserializeDocumentListOfNameServers(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("NameServer", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentListOfNameServersUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsRestxml_deserializeDocumentListOfResourceRecords(v *[]types.ResourceRecords, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ResourceRecords
	if *v == nil {
		sv = make([]types.ResourceRecords, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ResourceRecord", t.Name.Local):
			var col types.ResourceRecords
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsRestxml_deserializeDocumentResourceRecords(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentListOfResourceRecordsUnwrapped(v *[]types.ResourceRecords, decoder smithyxml.NodeDecoder) error {
	var sv []types.ResourceRecords
	if *v == nil {
		sv = make([]types.ResourceRecords, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ResourceRecords
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsRestxml_deserializeDocumentResourceRecords(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsRestxml_deserializeDocumentListOfResourceRecordSets(v *[]types.ResourceRecordSets, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ResourceRecordSets
	if *v == nil {
		sv = make([]types.ResourceRecordSets, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ResourceRecordSet", t.Name.Local):
			var col types.ResourceRecordSets
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsRestxml_deserializeDocumentResourceRecordSets(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentListOfResourceRecordSetsUnwrapped(v *[]types.ResourceRecordSets, decoder smithyxml.NodeDecoder) error {
	var sv []types.ResourceRecordSets
	if *v == nil {
		sv = make([]types.ResourceRecordSets, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ResourceRecordSets
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsRestxml_deserializeDocumentResourceRecordSets(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsRestxml_deserializeDocumentResourceRecords(v **types.ResourceRecords, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResourceRecords
	if *v == nil {
		sv = &types.ResourceRecords{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Value = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentResourceRecordSets(v **types.ResourceRecordSets, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResourceRecordSets
	if *v == nil {
		sv = &types.ResourceRecordSets{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Failover", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Failover = ptr.String(xtv)
			}

		case strings.EqualFold("Name", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Name = ptr.String(xtv)
			}

		case strings.EqualFold("Region", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Region = ptr.String(xtv)
			}

		case strings.EqualFold("ResourceRecords", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentListOfResourceRecords(&sv.ResourceRecords, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SetIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SetIdentifier = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("TTL", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.TTL = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Type", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Type = ptr.String(xtv)
			}

		case strings.EqualFold("Weight", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Weight = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("XniftyComment", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.XniftyComment = ptr.String(xtv)
			}

		case strings.EqualFold("XniftyHealthCheckConfig", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsRestxml_deserializeDocumentXniftyHealthCheckConfig(&sv.XniftyHealthCheckConfig, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsRestxml_deserializeDocumentXniftyHealthCheckConfig(v **types.XniftyHealthCheckConfig, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.XniftyHealthCheckConfig
	if *v == nil {
		sv = &types.XniftyHealthCheckConfig{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("FullyQualifiedDomainName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.FullyQualifiedDomainName = ptr.String(xtv)
			}

		case strings.EqualFold("IPAddress", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IPAddress = ptr.String(xtv)
			}

		case strings.EqualFold("Port", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Protocol", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Protocol = ptr.String(xtv)
			}

		case strings.EqualFold("ResourcePath", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ResourcePath = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
