// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/internal/serializers"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
	"math"
	"path"
)

type awsEc2query_serializeOpAllocateAddress struct {
}

func (*awsEc2query_serializeOpAllocateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAllocateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AllocateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AllocateAddress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAllocateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateAddress struct {
}

func (*awsEc2query_serializeOpAssociateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateAddress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAssociateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateMultiIpAddressGroup struct {
}

func (*awsEc2query_serializeOpAssociateMultiIpAddressGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateMultiIpAddressGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMultiIpAddressGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateMultiIpAddressGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAssociateMultiIpAddressGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateRouteTable struct {
}

func (*awsEc2query_serializeOpAssociateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateRouteTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAssociateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateUsers struct {
}

func (*awsEc2query_serializeOpAssociateUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateUsers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAssociateUsersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachIsoImage struct {
}

func (*awsEc2query_serializeOpAttachIsoImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachIsoImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachIsoImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachIsoImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAttachIsoImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachNetworkInterface struct {
}

func (*awsEc2query_serializeOpAttachNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachNetworkInterface")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAttachNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachVolume struct {
}

func (*awsEc2query_serializeOpAttachVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachVolume")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAttachVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAuthorizeSecurityGroupIngress struct {
}

func (*awsEc2query_serializeOpAuthorizeSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAuthorizeSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeSecurityGroupIngress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentAuthorizeSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelCopyInstances struct {
}

func (*awsEc2query_serializeOpCancelCopyInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelCopyInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelCopyInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelCopyInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCancelCopyInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelUpload struct {
}

func (*awsEc2query_serializeOpCancelUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelUpload")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCancelUploadInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpClearLoadBalancerSession struct {
}

func (*awsEc2query_serializeOpClearLoadBalancerSession) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpClearLoadBalancerSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ClearLoadBalancerSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ClearLoadBalancerSession")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentClearLoadBalancerSessionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpConfigureHealthCheck struct {
}

func (*awsEc2query_serializeOpConfigureHealthCheck) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpConfigureHealthCheck) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfigureHealthCheckInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ConfigureHealthCheck")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentConfigureHealthCheckInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCopyFromBackupInstance struct {
}

func (*awsEc2query_serializeOpCopyFromBackupInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCopyFromBackupInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyFromBackupInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopyFromBackupInstance")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCopyFromBackupInstanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCopyInstances struct {
}

func (*awsEc2query_serializeOpCopyInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCopyInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopyInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCopyInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateBackupInstances struct {
}

func (*awsEc2query_serializeOpCreateBackupInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateBackupInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateBackupInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateBackupInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateCustomerGateway struct {
}

func (*awsEc2query_serializeOpCreateCustomerGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateCustomerGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomerGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCustomerGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateCustomerGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateDhcpOptions struct {
}

func (*awsEc2query_serializeOpCreateDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateDhcpOptions")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateImageOperation struct {
}

func (*awsEc2query_serializeOpCreateImageOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateImageOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateImageOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateImageOperationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateInstanceBackupRule struct {
}

func (*awsEc2query_serializeOpCreateInstanceBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateInstanceBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInstanceBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateInstanceBackupRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateInstanceBackupRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateKeyPair struct {
}

func (*awsEc2query_serializeOpCreateKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateKeyPair")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateLoadBalancer struct {
}

func (*awsEc2query_serializeOpCreateLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateMultiIpAddressGroup struct {
}

func (*awsEc2query_serializeOpCreateMultiIpAddressGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateMultiIpAddressGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMultiIpAddressGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateMultiIpAddressGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateMultiIpAddressGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkInterface struct {
}

func (*awsEc2query_serializeOpCreateNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkInterface")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRemoteAccessVpnGateway struct {
}

func (*awsEc2query_serializeOpCreateRemoteAccessVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRemoteAccessVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRemoteAccessVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRemoteAccessVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateRemoteAccessVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRemoteAccessVpnGatewayUsers struct {
}

func (*awsEc2query_serializeOpCreateRemoteAccessVpnGatewayUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRemoteAccessVpnGatewayUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRemoteAccessVpnGatewayUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRemoteAccessVpnGatewayUsers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateRemoteAccessVpnGatewayUsersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRoute struct {
}

func (*awsEc2query_serializeOpCreateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRoute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRouteTable struct {
}

func (*awsEc2query_serializeOpCreateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRouteTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSecurityGroup struct {
}

func (*awsEc2query_serializeOpCreateSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSslCertificate struct {
}

func (*awsEc2query_serializeOpCreateSslCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSslCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSslCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSslCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateSslCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVolume struct {
}

func (*awsEc2query_serializeOpCreateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVolume")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpnConnection struct {
}

func (*awsEc2query_serializeOpCreateVpnConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpnConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpnConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpnConnection")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateVpnConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpnGateway struct {
}

func (*awsEc2query_serializeOpCreateVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentCreateVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteCustomerGateway struct {
}

func (*awsEc2query_serializeOpDeleteCustomerGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteCustomerGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomerGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteCustomerGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteCustomerGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteDhcpOptions struct {
}

func (*awsEc2query_serializeOpDeleteDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteDhcpOptions")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteImage struct {
}

func (*awsEc2query_serializeOpDeleteImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteInstanceBackupRule struct {
}

func (*awsEc2query_serializeOpDeleteInstanceBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteInstanceBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInstanceBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteInstanceBackupRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteInstanceBackupRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteIsoImage struct {
}

func (*awsEc2query_serializeOpDeleteIsoImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteIsoImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIsoImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteIsoImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteIsoImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteKeyPair struct {
}

func (*awsEc2query_serializeOpDeleteKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteKeyPair")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteLoadBalancer struct {
}

func (*awsEc2query_serializeOpDeleteLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteMultiIpAddressGroup struct {
}

func (*awsEc2query_serializeOpDeleteMultiIpAddressGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteMultiIpAddressGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMultiIpAddressGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteMultiIpAddressGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteMultiIpAddressGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkInterface struct {
}

func (*awsEc2query_serializeOpDeleteNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkInterface")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRemoteAccessVpnGateway struct {
}

func (*awsEc2query_serializeOpDeleteRemoteAccessVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRemoteAccessVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRemoteAccessVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRemoteAccessVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayConnections struct {
}

func (*awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRemoteAccessVpnGatewayConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRemoteAccessVpnGatewayConnections")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayUsers struct {
}

func (*awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRemoteAccessVpnGatewayUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRemoteAccessVpnGatewayUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRemoteAccessVpnGatewayUsers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayUsersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRoute struct {
}

func (*awsEc2query_serializeOpDeleteRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRoute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRouteTable struct {
}

func (*awsEc2query_serializeOpDeleteRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRouteTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSecurityGroup struct {
}

func (*awsEc2query_serializeOpDeleteSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSslCertificate struct {
}

func (*awsEc2query_serializeOpDeleteSslCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSslCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSslCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSslCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteSslCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVolume struct {
}

func (*awsEc2query_serializeOpDeleteVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVolume")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpnConnection struct {
}

func (*awsEc2query_serializeOpDeleteVpnConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpnConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpnConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpnConnection")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteVpnConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpnGateway struct {
}

func (*awsEc2query_serializeOpDeleteVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeleteVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterInstancesFromLoadBalancer struct {
}

func (*awsEc2query_serializeOpDeregisterInstancesFromLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterInstancesFromLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterInstancesFromLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterInstancesFromLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeregisterInstancesFromLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterInstancesFromSecurityGroup struct {
}

func (*awsEc2query_serializeOpDeregisterInstancesFromSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterInstancesFromSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterInstancesFromSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterInstancesFromSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDeregisterInstancesFromSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAddresses struct {
}

func (*awsEc2query_serializeOpDescribeAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAddresses")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAssociatedUsers struct {
}

func (*awsEc2query_serializeOpDescribeAssociatedUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAssociatedUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAssociatedUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAssociatedUsers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeAssociatedUsersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAvailabilityZones struct {
}

func (*awsEc2query_serializeOpDescribeAvailabilityZones) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAvailabilityZones) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAvailabilityZonesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAvailabilityZones")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeAvailabilityZonesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeCustomerGateways struct {
}

func (*awsEc2query_serializeOpDescribeCustomerGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeCustomerGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCustomerGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeCustomerGateways")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeCustomerGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeDhcpOptions struct {
}

func (*awsEc2query_serializeOpDescribeDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDhcpOptions")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeImages struct {
}

func (*awsEc2query_serializeOpDescribeImages) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeImages")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeImagesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceAttribute struct {
}

func (*awsEc2query_serializeOpDescribeInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceBackupRuleActivities struct {
}

func (*awsEc2query_serializeOpDescribeInstanceBackupRuleActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceBackupRuleActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceBackupRuleActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceBackupRuleActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceBackupRuleActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceBackupRules struct {
}

func (*awsEc2query_serializeOpDescribeInstanceBackupRules) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceBackupRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceBackupRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceBackupRules")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceBackupRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceHealth struct {
}

func (*awsEc2query_serializeOpDescribeInstanceHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceHealth")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceHealthInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstances struct {
}

func (*awsEc2query_serializeOpDescribeInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeIsoImages struct {
}

func (*awsEc2query_serializeOpDescribeIsoImages) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeIsoImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIsoImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIsoImages")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeIsoImagesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeKeyPairs struct {
}

func (*awsEc2query_serializeOpDescribeKeyPairs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeKeyPairs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeKeyPairsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeKeyPairs")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeKeyPairsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLoadBalancers struct {
}

func (*awsEc2query_serializeOpDescribeLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeMultiIpAddressGroups struct {
}

func (*awsEc2query_serializeOpDescribeMultiIpAddressGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeMultiIpAddressGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMultiIpAddressGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeMultiIpAddressGroups")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeMultiIpAddressGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInterfaces struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInterfaces")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRegions struct {
}

func (*awsEc2query_serializeOpDescribeRegions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRegions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRegionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRegions")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRegionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayActivities struct {
}

func (*awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRemoteAccessVpnGatewayActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRemoteAccessVpnGatewayActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayClientConfig struct {
}

func (*awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayClientConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayClientConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRemoteAccessVpnGatewayClientConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRemoteAccessVpnGatewayClientConfig")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayClientConfigInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayConnections struct {
}

func (*awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRemoteAccessVpnGatewayConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRemoteAccessVpnGatewayConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRemoteAccessVpnGatewayConnections")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRemoteAccessVpnGateways struct {
}

func (*awsEc2query_serializeOpDescribeRemoteAccessVpnGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRemoteAccessVpnGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRemoteAccessVpnGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRemoteAccessVpnGateways")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeResources struct {
}

func (*awsEc2query_serializeOpDescribeResources) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeResources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeResourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeResources")
	body.Key("Version").String("3.0")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRouteTables struct {
}

func (*awsEc2query_serializeOpDescribeRouteTables) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRouteTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRouteTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRouteTables")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeRouteTablesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSecurityActivities struct {
}

func (*awsEc2query_serializeOpDescribeSecurityActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSecurityActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSecurityActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeSecurityActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSecurityGroups struct {
}

func (*awsEc2query_serializeOpDescribeSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSecurityGroups")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeSecurityGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeServiceStatus struct {
}

func (*awsEc2query_serializeOpDescribeServiceStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeServiceStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeServiceStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeServiceStatus")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeServiceStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSslCertificateAttribute struct {
}

func (*awsEc2query_serializeOpDescribeSslCertificateAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSslCertificateAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSslCertificateAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSslCertificateAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeSslCertificateAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSslCertificates struct {
}

func (*awsEc2query_serializeOpDescribeSslCertificates) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSslCertificates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSslCertificatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSslCertificates")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeSslCertificatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeUploads struct {
}

func (*awsEc2query_serializeOpDescribeUploads) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeUploads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUploadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeUploads")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeUploadsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeUsage struct {
}

func (*awsEc2query_serializeOpDescribeUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeUsage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeUsageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeUserActivities struct {
}

func (*awsEc2query_serializeOpDescribeUserActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeUserActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeUserActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeUserActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVolumes struct {
}

func (*awsEc2query_serializeOpDescribeVolumes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVolumes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVolumes")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeVolumesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpnConnections struct {
}

func (*awsEc2query_serializeOpDescribeVpnConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpnConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpnConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpnConnections")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeVpnConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpnGateways struct {
}

func (*awsEc2query_serializeOpDescribeVpnGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpnGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpnGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpnGateways")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDescribeVpnGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachIsoImage struct {
}

func (*awsEc2query_serializeOpDetachIsoImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachIsoImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachIsoImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachIsoImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDetachIsoImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachNetworkInterface struct {
}

func (*awsEc2query_serializeOpDetachNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachNetworkInterface")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDetachNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachVolume struct {
}

func (*awsEc2query_serializeOpDetachVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachVolume")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDetachVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateAddress struct {
}

func (*awsEc2query_serializeOpDisassociateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateAddress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDisassociateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateMultiIpAddressGroup struct {
}

func (*awsEc2query_serializeOpDisassociateMultiIpAddressGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateMultiIpAddressGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMultiIpAddressGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateMultiIpAddressGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDisassociateMultiIpAddressGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateRouteTable struct {
}

func (*awsEc2query_serializeOpDisassociateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateRouteTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDisassociateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDissociateUsers struct {
}

func (*awsEc2query_serializeOpDissociateUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDissociateUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DissociateUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DissociateUsers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDissociateUsersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDownloadSslCertificate struct {
}

func (*awsEc2query_serializeOpDownloadSslCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDownloadSslCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DownloadSslCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DownloadSslCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentDownloadSslCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpExtendVolumeSize struct {
}

func (*awsEc2query_serializeOpExtendVolumeSize) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpExtendVolumeSize) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExtendVolumeSizeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExtendVolumeSize")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentExtendVolumeSizeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportInstanceOperation struct {
}

func (*awsEc2query_serializeOpImportInstanceOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportInstanceOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportInstanceOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportInstance")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentImportInstanceOperationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportKeyPair struct {
}

func (*awsEc2query_serializeOpImportKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportKeyPair")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentImportKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpIncreaseMultiIpAddressCount struct {
}

func (*awsEc2query_serializeOpIncreaseMultiIpAddressCount) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpIncreaseMultiIpAddressCount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IncreaseMultiIpAddressCountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("IncreaseMultiIpAddressCount")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentIncreaseMultiIpAddressCountInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyImageAttribute struct {
}

func (*awsEc2query_serializeOpModifyImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyImageAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceAttribute struct {
}

func (*awsEc2query_serializeOpModifyInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyInstanceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceBackupRuleAttribute struct {
}

func (*awsEc2query_serializeOpModifyInstanceBackupRuleAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceBackupRuleAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceBackupRuleAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceBackupRuleAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyInstanceBackupRuleAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyMultiIpAddressGroupAttribute struct {
}

func (*awsEc2query_serializeOpModifyMultiIpAddressGroupAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyMultiIpAddressGroupAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyMultiIpAddressGroupAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyMultiIpAddressGroupAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyMultiIpAddressGroupAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyNetworkInterfaceAttribute struct {
}

func (*awsEc2query_serializeOpModifyNetworkInterfaceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyNetworkInterfaceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyNetworkInterfaceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyNetworkInterfaceAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyNetworkInterfaceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyRemoteAccessVpnGatewayAttribute struct {
}

func (*awsEc2query_serializeOpModifyRemoteAccessVpnGatewayAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyRemoteAccessVpnGatewayAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyRemoteAccessVpnGatewayAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyRemoteAccessVpnGatewayAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyRemoteAccessVpnGatewayAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyRemoteAccessVpnGatewayUserAttribute struct {
}

func (*awsEc2query_serializeOpModifyRemoteAccessVpnGatewayUserAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyRemoteAccessVpnGatewayUserAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyRemoteAccessVpnGatewayUserAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyRemoteAccessVpnGatewayUserAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyRemoteAccessVpnGatewayUserAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifySslCertificateAttribute struct {
}

func (*awsEc2query_serializeOpModifySslCertificateAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifySslCertificateAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySslCertificateAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySslCertificateAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifySslCertificateAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVolumeAttribute struct {
}

func (*awsEc2query_serializeOpModifyVolumeAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVolumeAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVolumeAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVolumeAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentModifyVolumeAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyAssociateImage struct {
}

func (*awsEc2query_serializeOpNiftyAssociateImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyAssociateImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyAssociateImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyAssociateImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyAssociateImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyAssociateNatTable struct {
}

func (*awsEc2query_serializeOpNiftyAssociateNatTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyAssociateNatTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyAssociateNatTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyAssociateNatTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyAssociateNatTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyAssociateRouteTableWithElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyAssociateRouteTableWithElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyAssociateRouteTableWithElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyAssociateRouteTableWithElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyAssociateRouteTableWithElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyAssociateRouteTableWithElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyAssociateRouteTableWithVpnGateway struct {
}

func (*awsEc2query_serializeOpNiftyAssociateRouteTableWithVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyAssociateRouteTableWithVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyAssociateRouteTableWithVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyAssociateRouteTableWithVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyAssociateRouteTableWithVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyConfigureElasticLoadBalancerHealthCheck struct {
}

func (*awsEc2query_serializeOpNiftyConfigureElasticLoadBalancerHealthCheck) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyConfigureElasticLoadBalancerHealthCheck) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyConfigureElasticLoadBalancerHealthCheckInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyConfigureElasticLoadBalancerHealthCheck")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyConfigureElasticLoadBalancerHealthCheckInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateAlarm struct {
}

func (*awsEc2query_serializeOpNiftyCreateAlarm) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateAlarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateAlarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateAlarm")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateAlarmInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateAutoScalingGroup struct {
}

func (*awsEc2query_serializeOpNiftyCreateAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateAutoScalingGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateDhcpConfig struct {
}

func (*awsEc2query_serializeOpNiftyCreateDhcpConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateDhcpConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateDhcpConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateDhcpConfig")
	body.Key("Version").String("3.0")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateDhcpIpAddressPool struct {
}

func (*awsEc2query_serializeOpNiftyCreateDhcpIpAddressPool) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateDhcpIpAddressPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateDhcpIpAddressPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateDhcpIpAddressPool")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateDhcpIpAddressPoolInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateDhcpStaticMapping struct {
}

func (*awsEc2query_serializeOpNiftyCreateDhcpStaticMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateDhcpStaticMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateDhcpStaticMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateDhcpStaticMapping")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateDhcpStaticMappingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyCreateElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateInstanceSnapshot struct {
}

func (*awsEc2query_serializeOpNiftyCreateInstanceSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateInstanceSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateInstanceSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateInstanceSnapshot")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateInstanceSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateNatRule struct {
}

func (*awsEc2query_serializeOpNiftyCreateNatRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateNatRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateNatRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateNatRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateNatRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateNatTable struct {
}

func (*awsEc2query_serializeOpNiftyCreateNatTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateNatTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateNatTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateNatTable")
	body.Key("Version").String("3.0")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreatePrivateLan struct {
}

func (*awsEc2query_serializeOpNiftyCreatePrivateLan) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreatePrivateLan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreatePrivateLanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreatePrivateLan")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreatePrivateLanInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateRouter struct {
}

func (*awsEc2query_serializeOpNiftyCreateRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateRouter")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateRouterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateSeparateInstanceRule struct {
}

func (*awsEc2query_serializeOpNiftyCreateSeparateInstanceRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateSeparateInstanceRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateSeparateInstanceRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateSeparateInstanceRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateSeparateInstanceRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyCreateWebProxy struct {
}

func (*awsEc2query_serializeOpNiftyCreateWebProxy) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyCreateWebProxy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyCreateWebProxyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyCreateWebProxy")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyCreateWebProxyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteAlarm struct {
}

func (*awsEc2query_serializeOpNiftyDeleteAlarm) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteAlarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteAlarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteAlarm")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteAlarmInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteAutoScalingGroup struct {
}

func (*awsEc2query_serializeOpNiftyDeleteAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteAutoScalingGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteDhcpConfig struct {
}

func (*awsEc2query_serializeOpNiftyDeleteDhcpConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteDhcpConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteDhcpConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteDhcpConfig")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteDhcpConfigInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteDhcpIpAddressPool struct {
}

func (*awsEc2query_serializeOpNiftyDeleteDhcpIpAddressPool) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteDhcpIpAddressPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteDhcpIpAddressPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteDhcpIpAddressPool")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteDhcpIpAddressPoolInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteDhcpStaticMapping struct {
}

func (*awsEc2query_serializeOpNiftyDeleteDhcpStaticMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteDhcpStaticMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteDhcpStaticMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteDhcpStaticMapping")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteDhcpStaticMappingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyDeleteElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteInstanceSnapshot struct {
}

func (*awsEc2query_serializeOpNiftyDeleteInstanceSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteInstanceSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteInstanceSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteInstanceSnapshot")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteInstanceSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteNatRule struct {
}

func (*awsEc2query_serializeOpNiftyDeleteNatRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteNatRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteNatRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteNatRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteNatRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteNatTable struct {
}

func (*awsEc2query_serializeOpNiftyDeleteNatTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteNatTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteNatTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteNatTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteNatTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeletePrivateLan struct {
}

func (*awsEc2query_serializeOpNiftyDeletePrivateLan) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeletePrivateLan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeletePrivateLanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeletePrivateLan")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeletePrivateLanInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteRouter struct {
}

func (*awsEc2query_serializeOpNiftyDeleteRouter) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteRouter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteRouterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteRouter")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteRouterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteSeparateInstanceRule struct {
}

func (*awsEc2query_serializeOpNiftyDeleteSeparateInstanceRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteSeparateInstanceRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteSeparateInstanceRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteSeparateInstanceRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteSeparateInstanceRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeleteWebProxy struct {
}

func (*awsEc2query_serializeOpNiftyDeleteWebProxy) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeleteWebProxy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeleteWebProxyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeleteWebProxy")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeleteWebProxyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeregisterInstancesFromElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyDeregisterInstancesFromElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeregisterInstancesFromElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeregisterInstancesFromElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeregisterInstancesFromElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeregisterInstancesFromElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeregisterInstancesFromSeparateInstanceRule struct {
}

func (*awsEc2query_serializeOpNiftyDeregisterInstancesFromSeparateInstanceRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeregisterInstancesFromSeparateInstanceRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeregisterInstancesFromSeparateInstanceRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeregisterInstancesFromSeparateInstanceRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeregisterInstancesFromSeparateInstanceRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeregisterRoutersFromSecurityGroup struct {
}

func (*awsEc2query_serializeOpNiftyDeregisterRoutersFromSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeregisterRoutersFromSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeregisterRoutersFromSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeregisterRoutersFromSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeregisterRoutersFromSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDeregisterVpnGatewaysFromSecurityGroup struct {
}

func (*awsEc2query_serializeOpNiftyDeregisterVpnGatewaysFromSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDeregisterVpnGatewaysFromSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDeregisterVpnGatewaysFromSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDeregisterVpnGatewaysFromSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDeregisterVpnGatewaysFromSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeAlarmHistory struct {
}

func (*awsEc2query_serializeOpNiftyDescribeAlarmHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeAlarmHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeAlarmHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeAlarmHistory")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeAlarmHistoryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeAlarmRulesActivities struct {
}

func (*awsEc2query_serializeOpNiftyDescribeAlarmRulesActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeAlarmRulesActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeAlarmRulesActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeAlarmRulesActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeAlarmRulesActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeAlarms struct {
}

func (*awsEc2query_serializeOpNiftyDescribeAlarms) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeAlarms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeAlarmsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeAlarms")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeAlarmsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeAlarmsPartitions struct {
}

func (*awsEc2query_serializeOpNiftyDescribeAlarmsPartitions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeAlarmsPartitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeAlarmsPartitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeAlarmsPartitions")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeAlarmsPartitionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeAutoScalingGroups struct {
}

func (*awsEc2query_serializeOpNiftyDescribeAutoScalingGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeAutoScalingGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeAutoScalingGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeAutoScalingGroups")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeAutoScalingGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeCorporateInfoForCertificate struct {
}

func (*awsEc2query_serializeOpNiftyDescribeCorporateInfoForCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeCorporateInfoForCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeCorporateInfoForCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeCorporateInfoForCertificate")
	body.Key("Version").String("3.0")

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeDhcpConfigs struct {
}

func (*awsEc2query_serializeOpNiftyDescribeDhcpConfigs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeDhcpConfigs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeDhcpConfigsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeDhcpConfigs")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeDhcpConfigsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeDhcpStatus struct {
}

func (*awsEc2query_serializeOpNiftyDescribeDhcpStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeDhcpStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeDhcpStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeDhcpStatus")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeDhcpStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeElasticLoadBalancers struct {
}

func (*awsEc2query_serializeOpNiftyDescribeElasticLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeElasticLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeElasticLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeElasticLoadBalancers")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeElasticLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeInstanceElasticLoadBalancerHealth struct {
}

func (*awsEc2query_serializeOpNiftyDescribeInstanceElasticLoadBalancerHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeInstanceElasticLoadBalancerHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeInstanceElasticLoadBalancerHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeInstanceElasticLoadBalancerHealth")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeInstanceElasticLoadBalancerHealthInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeInstanceSnapshots struct {
}

func (*awsEc2query_serializeOpNiftyDescribeInstanceSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeInstanceSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeInstanceSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeInstanceSnapshots")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeInstanceSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeLoadBalancerSSLPolicies struct {
}

func (*awsEc2query_serializeOpNiftyDescribeLoadBalancerSSLPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeLoadBalancerSSLPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeLoadBalancerSSLPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeLoadBalancerSSLPolicies")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeLoadBalancerSSLPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeNatTables struct {
}

func (*awsEc2query_serializeOpNiftyDescribeNatTables) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeNatTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeNatTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeNatTables")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeNatTablesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribePerformanceChart struct {
}

func (*awsEc2query_serializeOpNiftyDescribePerformanceChart) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribePerformanceChart) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribePerformanceChartInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribePerformanceChart")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribePerformanceChartInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribePrivateLans struct {
}

func (*awsEc2query_serializeOpNiftyDescribePrivateLans) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribePrivateLans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribePrivateLansInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribePrivateLans")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribePrivateLansInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeRouters struct {
}

func (*awsEc2query_serializeOpNiftyDescribeRouters) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeRouters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeRoutersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeRouters")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeRoutersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeScalingActivities struct {
}

func (*awsEc2query_serializeOpNiftyDescribeScalingActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeScalingActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeScalingActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeScalingActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeScalingActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeSeparateInstanceRules struct {
}

func (*awsEc2query_serializeOpNiftyDescribeSeparateInstanceRules) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeSeparateInstanceRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeSeparateInstanceRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeSeparateInstanceRules")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeSeparateInstanceRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeVpnGatewayActivities struct {
}

func (*awsEc2query_serializeOpNiftyDescribeVpnGatewayActivities) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeVpnGatewayActivities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeVpnGatewayActivitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeVpnGatewayActivities")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeVpnGatewayActivitiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDescribeWebProxies struct {
}

func (*awsEc2query_serializeOpNiftyDescribeWebProxies) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDescribeWebProxies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDescribeWebProxiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDescribeWebProxies")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDescribeWebProxiesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDisableDhcp struct {
}

func (*awsEc2query_serializeOpNiftyDisableDhcp) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDisableDhcp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDisableDhcpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDisableDhcp")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDisableDhcpInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDisassociateNatTable struct {
}

func (*awsEc2query_serializeOpNiftyDisassociateNatTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDisassociateNatTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDisassociateNatTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDisassociateNatTable")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDisassociateNatTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDisassociateRouteTableFromElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyDisassociateRouteTableFromElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDisassociateRouteTableFromElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDisassociateRouteTableFromElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDisassociateRouteTableFromElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDisassociateRouteTableFromElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyDisassociateRouteTableFromVpnGateway struct {
}

func (*awsEc2query_serializeOpNiftyDisassociateRouteTableFromVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyDisassociateRouteTableFromVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyDisassociateRouteTableFromVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyDisassociateRouteTableFromVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyDisassociateRouteTableFromVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyEnableDhcp struct {
}

func (*awsEc2query_serializeOpNiftyEnableDhcp) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyEnableDhcp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyEnableDhcpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyEnableDhcp")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyEnableDhcpInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyAddressAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyAddressAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyAddressAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyAddressAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyAddressAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyAddressAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyCustomerGatewayAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyCustomerGatewayAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyCustomerGatewayAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyCustomerGatewayAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyCustomerGatewayAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyCustomerGatewayAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyElasticLoadBalancerAttributes struct {
}

func (*awsEc2query_serializeOpNiftyModifyElasticLoadBalancerAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyElasticLoadBalancerAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyElasticLoadBalancerAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyElasticLoadBalancerAttributes")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyElasticLoadBalancerAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyInstanceSnapshotAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyInstanceSnapshotAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyInstanceSnapshotAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyInstanceSnapshotAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyInstanceSnapshotAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyInstanceSnapshotAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyKeyPairAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyKeyPairAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyKeyPairAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyKeyPairAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyKeyPairAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyKeyPairAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyPrivateLanAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyPrivateLanAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyPrivateLanAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyPrivateLanAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyPrivateLanAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyPrivateLanAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyRouterAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyRouterAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyRouterAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyRouterAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyRouterAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyRouterAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyVpnGatewayAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyVpnGatewayAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyVpnGatewayAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyVpnGatewayAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyVpnGatewayAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyVpnGatewayAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyModifyWebProxyAttribute struct {
}

func (*awsEc2query_serializeOpNiftyModifyWebProxyAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyModifyWebProxyAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyModifyWebProxyAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyModifyWebProxyAttribute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyModifyWebProxyAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRebootRouters struct {
}

func (*awsEc2query_serializeOpNiftyRebootRouters) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRebootRouters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRebootRoutersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRebootRouters")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRebootRoutersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRebootVpnGateways struct {
}

func (*awsEc2query_serializeOpNiftyRebootVpnGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRebootVpnGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRebootVpnGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRebootVpnGateways")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRebootVpnGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRegisterInstancesWithElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyRegisterInstancesWithElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRegisterInstancesWithElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRegisterInstancesWithElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRegisterInstancesWithElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRegisterInstancesWithElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRegisterInstancesWithSeparateInstanceRule struct {
}

func (*awsEc2query_serializeOpNiftyRegisterInstancesWithSeparateInstanceRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRegisterInstancesWithSeparateInstanceRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRegisterInstancesWithSeparateInstanceRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRegisterInstancesWithSeparateInstanceRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRegisterInstancesWithSeparateInstanceRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRegisterPortWithElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyRegisterPortWithElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRegisterPortWithElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRegisterPortWithElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRegisterPortWithElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRegisterPortWithElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRegisterRoutersWithSecurityGroup struct {
}

func (*awsEc2query_serializeOpNiftyRegisterRoutersWithSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRegisterRoutersWithSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRegisterRoutersWithSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRegisterRoutersWithSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRegisterRoutersWithSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRegisterVpnGatewaysWithSecurityGroup struct {
}

func (*awsEc2query_serializeOpNiftyRegisterVpnGatewaysWithSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRegisterVpnGatewaysWithSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRegisterVpnGatewaysWithSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRegisterVpnGatewaysWithSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRegisterVpnGatewaysWithSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReleaseRouterBackupState struct {
}

func (*awsEc2query_serializeOpNiftyReleaseRouterBackupState) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReleaseRouterBackupState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReleaseRouterBackupStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReleaseRouterBackupState")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReleaseRouterBackupStateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReleaseVpnGatewayBackupState struct {
}

func (*awsEc2query_serializeOpNiftyReleaseVpnGatewayBackupState) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReleaseVpnGatewayBackupState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReleaseVpnGatewayBackupStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReleaseVpnGatewayBackupState")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReleaseVpnGatewayBackupStateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceDhcpConfig struct {
}

func (*awsEc2query_serializeOpNiftyReplaceDhcpConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceDhcpConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceDhcpConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceDhcpConfig")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceDhcpConfigInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceDhcpOption struct {
}

func (*awsEc2query_serializeOpNiftyReplaceDhcpOption) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceDhcpOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceDhcpOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceDhcpOption")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceDhcpOptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerLatestVersion struct {
}

func (*awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerLatestVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerLatestVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceElasticLoadBalancerLatestVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceElasticLoadBalancerLatestVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceElasticLoadBalancerLatestVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerListenerSSLCertificate struct {
}

func (*awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerListenerSSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceElasticLoadBalancerListenerSSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceElasticLoadBalancerListenerSSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceElasticLoadBalancerListenerSSLCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceElasticLoadBalancerListenerSSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceNatRule struct {
}

func (*awsEc2query_serializeOpNiftyReplaceNatRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceNatRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceNatRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceNatRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceNatRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceNatTableAssociation struct {
}

func (*awsEc2query_serializeOpNiftyReplaceNatTableAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceNatTableAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceNatTableAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceNatTableAssociation")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceNatTableAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceRouterLatestVersion struct {
}

func (*awsEc2query_serializeOpNiftyReplaceRouterLatestVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceRouterLatestVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceRouterLatestVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceRouterLatestVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceRouterLatestVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceRouteTableAssociationWithElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceRouteTableAssociationWithElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceRouteTableAssociationWithElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithVpnGateway struct {
}

func (*awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceRouteTableAssociationWithVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceRouteTableAssociationWithVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceRouteTableAssociationWithVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceRouteTableAssociationWithVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyReplaceVpnGatewayLatestVersion struct {
}

func (*awsEc2query_serializeOpNiftyReplaceVpnGatewayLatestVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyReplaceVpnGatewayLatestVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyReplaceVpnGatewayLatestVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyReplaceVpnGatewayLatestVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyReplaceVpnGatewayLatestVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRestoreInstanceSnapshot struct {
}

func (*awsEc2query_serializeOpNiftyRestoreInstanceSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRestoreInstanceSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRestoreInstanceSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRestoreInstanceSnapshot")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRestoreInstanceSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRestoreRouterPreviousVersion struct {
}

func (*awsEc2query_serializeOpNiftyRestoreRouterPreviousVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRestoreRouterPreviousVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRestoreRouterPreviousVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRestoreRouterPreviousVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRestoreRouterPreviousVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRestoreVpnGatewayPreviousVersion struct {
}

func (*awsEc2query_serializeOpNiftyRestoreVpnGatewayPreviousVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRestoreVpnGatewayPreviousVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRestoreVpnGatewayPreviousVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRestoreVpnGatewayPreviousVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRestoreVpnGatewayPreviousVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyRetryImportInstance struct {
}

func (*awsEc2query_serializeOpNiftyRetryImportInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyRetryImportInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyRetryImportInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyRetryImportInstance")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyRetryImportInstanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftySetLoadBalancerSSLPoliciesOfListener struct {
}

func (*awsEc2query_serializeOpNiftySetLoadBalancerSSLPoliciesOfListener) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftySetLoadBalancerSSLPoliciesOfListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftySetLoadBalancerSSLPoliciesOfListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftySetLoadBalancerSSLPoliciesOfListener")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftySetLoadBalancerSSLPoliciesOfListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUnsetLoadBalancerSSLPoliciesOfListener struct {
}

func (*awsEc2query_serializeOpNiftyUnsetLoadBalancerSSLPoliciesOfListener) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUnsetLoadBalancerSSLPoliciesOfListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUnsetLoadBalancerSSLPoliciesOfListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUnsetLoadBalancerSSLPoliciesOfListener")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUnsetLoadBalancerSSLPoliciesOfListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateAlarm struct {
}

func (*awsEc2query_serializeOpNiftyUpdateAlarm) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateAlarm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateAlarmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateAlarm")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateAlarmInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateAutoScalingGroup struct {
}

func (*awsEc2query_serializeOpNiftyUpdateAutoScalingGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateAutoScalingGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateAutoScalingGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateAutoScalingGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateAutoScalingGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateElasticLoadBalancer struct {
}

func (*awsEc2query_serializeOpNiftyUpdateElasticLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateElasticLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateElasticLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateElasticLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateElasticLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateInstanceNetworkInterfaces struct {
}

func (*awsEc2query_serializeOpNiftyUpdateInstanceNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateInstanceNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateInstanceNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateInstanceNetworkInterfaces")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateInstanceNetworkInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateRouterNetworkInterfaces struct {
}

func (*awsEc2query_serializeOpNiftyUpdateRouterNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateRouterNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateRouterNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateRouterNetworkInterfaces")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateRouterNetworkInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateSeparateInstanceRule struct {
}

func (*awsEc2query_serializeOpNiftyUpdateSeparateInstanceRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateSeparateInstanceRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateSeparateInstanceRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateSeparateInstanceRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateSeparateInstanceRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpNiftyUpdateVpnGatewayNetworkInterfaces struct {
}

func (*awsEc2query_serializeOpNiftyUpdateVpnGatewayNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpNiftyUpdateVpnGatewayNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NiftyUpdateVpnGatewayNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("NiftyUpdateVpnGatewayNetworkInterfaces")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentNiftyUpdateVpnGatewayNetworkInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRebootInstances struct {
}

func (*awsEc2query_serializeOpRebootInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRebootInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RebootInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRebootInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRebootRemoteAccessVpnGateway struct {
}

func (*awsEc2query_serializeOpRebootRemoteAccessVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRebootRemoteAccessVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootRemoteAccessVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RebootRemoteAccessVpnGateway")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRebootRemoteAccessVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRefreshInstanceBackupRule struct {
}

func (*awsEc2query_serializeOpRefreshInstanceBackupRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRefreshInstanceBackupRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RefreshInstanceBackupRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RefreshInstanceBackupRule")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRefreshInstanceBackupRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterCorporateInfoForCertificate struct {
}

func (*awsEc2query_serializeOpRegisterCorporateInfoForCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterCorporateInfoForCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterCorporateInfoForCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterCorporateInfoForCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRegisterCorporateInfoForCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterInstancesWithLoadBalancer struct {
}

func (*awsEc2query_serializeOpRegisterInstancesWithLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterInstancesWithLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterInstancesWithLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterInstancesWithLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRegisterInstancesWithLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterInstancesWithSecurityGroup struct {
}

func (*awsEc2query_serializeOpRegisterInstancesWithSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterInstancesWithSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterInstancesWithSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterInstancesWithSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRegisterInstancesWithSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterPortWithLoadBalancer struct {
}

func (*awsEc2query_serializeOpRegisterPortWithLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterPortWithLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterPortWithLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterPortWithLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRegisterPortWithLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReleaseAddress struct {
}

func (*awsEc2query_serializeOpReleaseAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReleaseAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReleaseAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReleaseAddress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentReleaseAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReleaseMultiIpAddresses struct {
}

func (*awsEc2query_serializeOpReleaseMultiIpAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReleaseMultiIpAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReleaseMultiIpAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReleaseMultiIpAddresses")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentReleaseMultiIpAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceRemoteAccessVpnGatewayLatestVersion struct {
}

func (*awsEc2query_serializeOpReplaceRemoteAccessVpnGatewayLatestVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceRemoteAccessVpnGatewayLatestVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceRemoteAccessVpnGatewayLatestVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceRemoteAccessVpnGatewayLatestVersion")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentReplaceRemoteAccessVpnGatewayLatestVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceRoute struct {
}

func (*awsEc2query_serializeOpReplaceRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceRoute")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentReplaceRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceRouteTableAssociation struct {
}

func (*awsEc2query_serializeOpReplaceRouteTableAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceRouteTableAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceRouteTableAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceRouteTableAssociation")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentReplaceRouteTableAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRevokeSecurityGroupIngress struct {
}

func (*awsEc2query_serializeOpRevokeSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRevokeSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeSecurityGroupIngress")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRevokeSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRunInstances struct {
}

func (*awsEc2query_serializeOpRunInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRunInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RunInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentRunInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSetFilterForLoadBalancer struct {
}

func (*awsEc2query_serializeOpSetFilterForLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSetFilterForLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetFilterForLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetFilterForLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentSetFilterForLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSetLoadBalancerListenerSSLCertificate struct {
}

func (*awsEc2query_serializeOpSetLoadBalancerListenerSSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSetLoadBalancerListenerSSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLoadBalancerListenerSSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetLoadBalancerListenerSSLCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentSetLoadBalancerListenerSSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSetRemoteAccessVpnGatewayCACertificate struct {
}

func (*awsEc2query_serializeOpSetRemoteAccessVpnGatewayCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSetRemoteAccessVpnGatewayCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetRemoteAccessVpnGatewayCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetRemoteAccessVpnGatewayCACertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentSetRemoteAccessVpnGatewayCACertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSetRemoteAccessVpnGatewaySSLCertificate struct {
}

func (*awsEc2query_serializeOpSetRemoteAccessVpnGatewaySSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSetRemoteAccessVpnGatewaySSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetRemoteAccessVpnGatewaySSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetRemoteAccessVpnGatewaySSLCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentSetRemoteAccessVpnGatewaySSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStartInstances struct {
}

func (*awsEc2query_serializeOpStartInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStartInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentStartInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStopInstances struct {
}

func (*awsEc2query_serializeOpStopInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStopInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StopInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentStopInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpTerminateInstances struct {
}

func (*awsEc2query_serializeOpTerminateInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpTerminateInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TerminateInstances")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentTerminateInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnsetLoadBalancerListenerSSLCertificate struct {
}

func (*awsEc2query_serializeOpUnsetLoadBalancerListenerSSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnsetLoadBalancerListenerSSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnsetLoadBalancerListenerSSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnsetLoadBalancerListenerSSLCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUnsetLoadBalancerListenerSSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnsetRemoteAccessVpnGatewayCACertificate struct {
}

func (*awsEc2query_serializeOpUnsetRemoteAccessVpnGatewayCACertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnsetRemoteAccessVpnGatewayCACertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnsetRemoteAccessVpnGatewayCACertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnsetRemoteAccessVpnGatewayCACertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUnsetRemoteAccessVpnGatewayCACertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnsetRemoteAccessVpnGatewaySSLCertificate struct {
}

func (*awsEc2query_serializeOpUnsetRemoteAccessVpnGatewaySSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnsetRemoteAccessVpnGatewaySSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnsetRemoteAccessVpnGatewaySSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnsetRemoteAccessVpnGatewaySSLCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUnsetRemoteAccessVpnGatewaySSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUpdateLoadBalancer struct {
}

func (*awsEc2query_serializeOpUpdateLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUpdateLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateLoadBalancer")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUpdateLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUpdateLoadBalancerOption struct {
}

func (*awsEc2query_serializeOpUpdateLoadBalancerOption) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUpdateLoadBalancerOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLoadBalancerOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateLoadBalancerOption")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUpdateLoadBalancerOptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUpdateSecurityGroup struct {
}

func (*awsEc2query_serializeOpUpdateSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUpdateSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateSecurityGroup")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUpdateSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUploadIsoImage struct {
}

func (*awsEc2query_serializeOpUploadIsoImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUploadIsoImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadIsoImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UploadIsoImage")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUploadIsoImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUploadSslCertificate struct {
}

func (*awsEc2query_serializeOpUploadSslCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUploadSslCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadSslCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/api/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UploadSslCertificate")
	body.Key("Version").String("3.0")

	if err := awsEc2query_serializeOpDocumentUploadSslCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsEc2query_serializeDocumentListOfRequestAccountingType(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestAdd(v []types.RequestAdd, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestAdd(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestAdditionalAttributes(v *types.ListOfRequestAdditionalAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestAdditionalAttributesMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestAdditionalAttributesMember(v []types.RequestAdditionalAttributes, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestAdditionalAttributes(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestAllocationId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestAutoScalingGroupName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestAvailabilityZones(v *types.ListOfRequestAvailabilityZones, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestAvailabilityZonesMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestAvailabilityZonesMember(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestBlockDeviceMapping(v []types.RequestBlockDeviceMapping, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestBlockDeviceMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestCipherSuite(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestConnection(v []types.RequestConnection, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestConnection(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestConversionTaskId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestCustomerGatewayId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDataType(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDhcpConfigId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDhcpConfiguration(v []types.RequestDhcpConfiguration, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestDhcpConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDhcpOptionsId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDiskImage(v []types.RequestDiskImage, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestDiskImage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestDistributionId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerPort(v []int32, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerProtocol(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestEmailAddress(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestExecutableBy(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestExpectation(v *types.ListOfRequestExpectation, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestExpectationMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestExpectationMember(v []types.RequestExpectation, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestExpectation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestExpectationOfNiftyCreateElasticLoadBalancer(v *types.ListOfRequestExpectationOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestExpectationOfNiftyCreateElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestExpectationOfNiftyCreateElasticLoadBalancerMember(v []types.RequestExpectationOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestExpectationOfNiftyCreateElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilter(v []types.RequestFilter, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeAddresses(v []types.RequestFilterOfDescribeAddresses, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeAddresses(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeCustomerGateways(v []types.RequestFilterOfDescribeCustomerGateways, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeCustomerGateways(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeDhcpOptions(v []types.RequestFilterOfDescribeDhcpOptions, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeDhcpOptions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeNetworkInterfaces(v []types.RequestFilterOfDescribeNetworkInterfaces, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeNetworkInterfaces(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeRegions(v []types.RequestFilterOfDescribeRegions, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeRegions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeRouteTables(v []types.RequestFilterOfDescribeRouteTables, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeRouteTables(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeSecurityGroups(v []types.RequestFilterOfDescribeSecurityGroups, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeSecurityGroups(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeVpnConnections(v []types.RequestFilterOfDescribeVpnConnections, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeVpnConnections(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfDescribeVpnGateways(v []types.RequestFilterOfDescribeVpnGateways, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfDescribeVpnGateways(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeDhcpConfigs(v []types.RequestFilterOfNiftyDescribeDhcpConfigs, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeDhcpConfigs(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeElasticLoadBalancers(v []types.RequestFilterOfNiftyDescribeElasticLoadBalancers, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeElasticLoadBalancers(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeNatTables(v []types.RequestFilterOfNiftyDescribeNatTables, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeNatTables(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribePrivateLans(v []types.RequestFilterOfNiftyDescribePrivateLans, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribePrivateLans(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeRouters(v []types.RequestFilterOfNiftyDescribeRouters, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeRouters(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeSeparateInstanceRules(v []types.RequestFilterOfNiftyDescribeSeparateInstanceRules, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeSeparateInstanceRules(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeWebProxies(v []types.RequestFilterOfNiftyDescribeWebProxies, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeWebProxies(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFqdn(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestFqdnId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestGroupName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestGroups(v []types.RequestGroups, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestGroups(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestImageId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestImageName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstanceBackupRuleId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstanceId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancePort(v []int32, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstances(v *types.ListOfRequestInstances, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesMember(v []types.RequestInstances, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstances(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstanceSnapshotId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfDescribeInstanceHealth(v *types.ListOfRequestInstancesOfDescribeInstanceHealth, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfDescribeInstanceHealthMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfDescribeInstanceHealthMember(v []types.RequestInstancesOfDescribeInstanceHealth, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstancesOfDescribeInstanceHealth(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyCreateElasticLoadBalancer(v *types.ListOfRequestInstancesOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyCreateElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyCreateElasticLoadBalancerMember(v []types.RequestInstancesOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstancesOfNiftyCreateElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer(v *types.ListOfRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancerMember(v []types.RequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth(v *types.ListOfRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealthMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealthMember(v []types.RequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer(v *types.ListOfRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancerMember(v []types.RequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstanceType(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestInstanceUniqueId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestIpAddress(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestIPAddresses(v *types.ListOfRequestIPAddresses, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestIPAddressesMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestIPAddressesMember(v []types.RequestIPAddresses, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestIPAddresses(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestIpPermissions(v []types.RequestIpPermissions, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestIpPermissions(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestIpPermissionsOfRevokeSecurityGroupIngress(v []types.RequestIpPermissionsOfRevokeSecurityGroupIngress, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestIpPermissionsOfRevokeSecurityGroupIngress(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestIpRanges(v []types.RequestIpRanges, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestIpRanges(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestKeyName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLicense(v []types.RequestLicense, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestLicense(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestListeners(v *types.ListOfRequestListeners, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestListenersMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersMember(v []types.RequestListeners, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestListeners(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfNiftyCreateElasticLoadBalancer(v *types.ListOfRequestListenersOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfNiftyCreateElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfNiftyCreateElasticLoadBalancerMember(v []types.RequestListenersOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestListenersOfNiftyCreateElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfNiftyRegisterPortWithElasticLoadBalancer(v *types.ListOfRequestListenersOfNiftyRegisterPortWithElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfNiftyRegisterPortWithElasticLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfNiftyRegisterPortWithElasticLoadBalancerMember(v []types.RequestListenersOfNiftyRegisterPortWithElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestListenersOfNiftyRegisterPortWithElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfRegisterPortWithLoadBalancer(v *types.ListOfRequestListenersOfRegisterPortWithLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfRegisterPortWithLoadBalancerMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestListenersOfRegisterPortWithLoadBalancerMember(v []types.RequestListenersOfRegisterPortWithLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestListenersOfRegisterPortWithLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancerName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancerNames(v *types.ListOfRequestLoadBalancerNames, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancerNamesMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancerNamesMember(v []types.RequestLoadBalancerNames, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestLoadBalancerNames(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancerPort(v []int32, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancers(v []types.RequestLoadBalancers, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestLoadBalancers(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancersOfNiftyCreateAutoScalingGroup(v []types.RequestLoadBalancersOfNiftyCreateAutoScalingGroup, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestLoadBalancersOfNiftyCreateAutoScalingGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestLoadBalancersOfNiftyUpdateAutoScalingGroup(v []types.RequestLoadBalancersOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestLoadBalancersOfNiftyUpdateAutoScalingGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestMultiIpAddressGroupId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNatTableId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterface(v []types.RequestNetworkInterface, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterface(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCopyFromBackupInstance(v []types.RequestNetworkInterfaceOfCopyFromBackupInstance, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfCopyFromBackupInstance(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCreateRemoteAccessVpnGateway(v []types.RequestNetworkInterfaceOfCreateRemoteAccessVpnGateway, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfCreateRemoteAccessVpnGateway(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCreateVpnGateway(v []types.RequestNetworkInterfaceOfCreateVpnGateway, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfCreateVpnGateway(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer(v []types.RequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyCreateRouter(v []types.RequestNetworkInterfaceOfNiftyCreateRouter, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyCreateRouter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion(v []types.RequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces(v []types.RequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces(v []types.RequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNiftyCustomerGatewayName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestNiftyVpnGatewayName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestOwner(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestPartition(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestPrivateIpAddress(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestPrivateLanName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestProductCode(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestProtocol(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestPublicIp(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRegionName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRemoteAccessVpnGatewayId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRemoteUser(v []types.RequestRemoteUser, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRemoteUser(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers(v []types.RequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRemove(v []types.RequestRemove, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRemove(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestResourceName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRouter(v []types.RequestRouter, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRouter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRouterId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRouterName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRouterSet(v []types.RequestRouterSet, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRouterSet(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRouteTableId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRule(v []types.RequestRule, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarmHistory(v []types.RequestRuleOfNiftyDescribeAlarmHistory, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarmHistory(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarmRulesActivities(v []types.RequestRuleOfNiftyDescribeAlarmRulesActivities, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarmRulesActivities(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarms(v []types.RequestRuleOfNiftyDescribeAlarms, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarms(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestRuleOfNiftyUpdateAlarm(v []types.RequestRuleOfNiftyUpdateAlarm, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestRuleOfNiftyUpdateAlarm(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestScalingSchedule(v []types.RequestScalingSchedule, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestScalingSchedule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestScalingScheduleOfNiftyUpdateAutoScalingGroup(v []types.RequestScalingScheduleOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestScalingScheduleOfNiftyUpdateAutoScalingGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestScalingTrigger(v []types.RequestScalingTrigger, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestScalingTrigger(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestScalingTriggerOfNiftyUpdateAutoScalingGroup(v []types.RequestScalingTriggerOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestScalingTriggerOfNiftyUpdateAutoScalingGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestSecurityGroup(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestSecurityGroupId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestSeparateInstanceRuleName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestSnapshotName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestSystemIpAddresses(v []types.RequestSystemIpAddresses, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestSystemIpAddresses(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestTenancy(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestUsers(v *types.ListOfRequestUsers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Member != nil {
		objectKey := object.FlatKey("member")
		if err := awsEc2query_serializeDocumentListOfRequestUsersMember(v.Member, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentListOfRequestUsersMember(v []types.RequestUsers, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestUsers(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestValue(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestVolumeId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestVpnConnectionId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestVpnGateway(v []types.RequestVpnGateway, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestVpnGateway(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestVpnGatewayId(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestVpnGatewaySet(v []types.RequestVpnGatewaySet, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRequestVpnGatewaySet(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentListOfRequestZoneName(v []string, value query.Value) error {
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRequestAdd(v *types.RequestAdd, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Group != nil {
		objectKey := object.Key("Group")
		objectKey.String(*v.Group)
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestAdditionalAttributes(v *types.RequestAdditionalAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Key) > 0 {
		objectKey := object.Key("Key")
		objectKey.String(string(v.Key))
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestBlockDeviceMapping(v *types.RequestBlockDeviceMapping, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.RequestEbs != nil {
		objectKey := object.Key("Ebs")
		if err := awsEc2query_serializeDocumentRequestEbs(v.RequestEbs, objectKey); err != nil {
			return err
		}
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestBypassInterface(v *types.RequestBypassInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestCertInfo(v *types.RequestCertInfo, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CountryName != nil {
		objectKey := object.Key("CountryName")
		objectKey.String(*v.CountryName)
	}

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	if v.LocationName != nil {
		objectKey := object.Key("LocationName")
		objectKey.String(*v.LocationName)
	}

	if v.OrganizationName != nil {
		objectKey := object.Key("OrganizationName")
		objectKey.String(*v.OrganizationName)
	}

	if v.OrganizationUnitName != nil {
		objectKey := object.Key("OrganizationUnitName")
		objectKey.String(*v.OrganizationUnitName)
	}

	if v.StateName != nil {
		objectKey := object.Key("StateName")
		objectKey.String(*v.StateName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestConnection(v *types.RequestConnection, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConnectionId != nil {
		objectKey := object.Key("ConnectionId")
		objectKey.String(*v.ConnectionId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestCopyInstance(v *types.RequestCopyInstance, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.InstanceName != nil {
		objectKey := object.Key("InstanceName")
		objectKey.String(*v.InstanceName)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if len(v.IpType) > 0 {
		objectKey := object.Key("IpType")
		objectKey.String(string(v.IpType))
	}

	if v.ListOfRequestLoadBalancers != nil {
		objectKey := object.FlatKey("LoadBalancers")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancers(v.ListOfRequestLoadBalancers, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestSecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.ListOfRequestSecurityGroup, objectKey); err != nil {
			return err
		}
	}

	if v.RequestPlacement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCopyInstances(v.RequestPlacement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDay(v *types.RequestDay, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.SetFriday) > 0 {
		objectKey := object.Key("SetFriday")
		objectKey.String(string(v.SetFriday))
	}

	if len(v.SetMonday) > 0 {
		objectKey := object.Key("SetMonday")
		objectKey.String(string(v.SetMonday))
	}

	if len(v.SetSaturday) > 0 {
		objectKey := object.Key("SetSaturday")
		objectKey.String(string(v.SetSaturday))
	}

	if len(v.SetSunday) > 0 {
		objectKey := object.Key("SetSunday")
		objectKey.String(string(v.SetSunday))
	}

	if len(v.SetThursday) > 0 {
		objectKey := object.Key("SetThursday")
		objectKey.String(string(v.SetThursday))
	}

	if len(v.SetTuesday) > 0 {
		objectKey := object.Key("SetTuesday")
		objectKey.String(string(v.SetTuesday))
	}

	if len(v.SetWednesday) > 0 {
		objectKey := object.Key("SetWednesday")
		objectKey.String(string(v.SetWednesday))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDayOfNiftyUpdateAutoScalingGroup(v *types.RequestDayOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.SetFriday) > 0 {
		objectKey := object.Key("SetFriday")
		objectKey.String(string(v.SetFriday))
	}

	if len(v.SetMonday) > 0 {
		objectKey := object.Key("SetMonday")
		objectKey.String(string(v.SetMonday))
	}

	if len(v.SetSaturday) > 0 {
		objectKey := object.Key("SetSaturday")
		objectKey.String(string(v.SetSaturday))
	}

	if len(v.SetSunday) > 0 {
		objectKey := object.Key("SetSunday")
		objectKey.String(string(v.SetSunday))
	}

	if len(v.SetThursday) > 0 {
		objectKey := object.Key("SetThursday")
		objectKey.String(string(v.SetThursday))
	}

	if len(v.SetTuesday) > 0 {
		objectKey := object.Key("SetTuesday")
		objectKey.String(string(v.SetTuesday))
	}

	if len(v.SetWednesday) > 0 {
		objectKey := object.Key("SetWednesday")
		objectKey.String(string(v.SetWednesday))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDDay(v *types.RequestDDay, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndingDDay != nil {
		objectKey := object.Key("EndingDDay")
		objectKey.String(*v.EndingDDay)
	}

	if v.StartingDDay != nil {
		objectKey := object.Key("StartingDDay")
		objectKey.String(*v.StartingDDay)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDescription(v *types.RequestDescription, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDestination(v *types.RequestDestination, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDhcpConfiguration(v *types.RequestDhcpConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Key) > 0 {
		objectKey := object.Key("Key")
		objectKey.String(string(v.Key))
	}

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestDiskImage(v *types.RequestDiskImage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.RequestImage != nil {
		objectKey := object.Key("Image")
		if err := awsEc2query_serializeDocumentRequestImage(v.RequestImage, objectKey); err != nil {
			return err
		}
	}

	if v.RequestVolume != nil {
		objectKey := object.Key("Volume")
		if err := awsEc2query_serializeDocumentRequestVolume(v.RequestVolume, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestEbs(v *types.RequestEbs, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination != nil {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(*v.DeleteOnTermination)
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.Boolean(*v.NoDevice)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.VolumeSize != nil {
		objectKey := object.Key("VolumeSize")
		objectKey.Integer(*v.VolumeSize)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestElasticLoadBalancers(v *types.RequestElasticLoadBalancers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestElasticLoadBalancerId != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerId")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerId(v.ListOfRequestElasticLoadBalancerId, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestElasticLoadBalancerName != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerName")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerName(v.ListOfRequestElasticLoadBalancerName, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestElasticLoadBalancerPort != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerPort")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerPort(v.ListOfRequestElasticLoadBalancerPort, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestInstancePort != nil {
		objectKey := object.FlatKey("InstancePort")
		if err := awsEc2query_serializeDocumentListOfRequestInstancePort(v.ListOfRequestInstancePort, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestProtocol != nil {
		objectKey := object.FlatKey("Protocol")
		if err := awsEc2query_serializeDocumentListOfRequestProtocol(v.ListOfRequestProtocol, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestExpectation(v *types.RequestExpectation, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HttpCode != nil {
		objectKey := object.Key("HttpCode")
		objectKey.String(*v.HttpCode)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestExpectationOfNiftyCreateElasticLoadBalancer(v *types.RequestExpectationOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.HttpCode) > 0 {
		objectKey := object.Key("HttpCode")
		objectKey.String(string(v.HttpCode))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilter(v *types.RequestFilter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeAddresses(v *types.RequestFilterOfDescribeAddresses, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeCustomerGateways(v *types.RequestFilterOfDescribeCustomerGateways, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeDhcpOptions(v *types.RequestFilterOfDescribeDhcpOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeNetworkInterfaces(v *types.RequestFilterOfDescribeNetworkInterfaces, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeRegions(v *types.RequestFilterOfDescribeRegions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeRouteTables(v *types.RequestFilterOfDescribeRouteTables, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeSecurityGroups(v *types.RequestFilterOfDescribeSecurityGroups, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeVpnConnections(v *types.RequestFilterOfDescribeVpnConnections, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfDescribeVpnGateways(v *types.RequestFilterOfDescribeVpnGateways, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeDhcpConfigs(v *types.RequestFilterOfNiftyDescribeDhcpConfigs, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeElasticLoadBalancers(v *types.RequestFilterOfNiftyDescribeElasticLoadBalancers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeNatTables(v *types.RequestFilterOfNiftyDescribeNatTables, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribePrivateLans(v *types.RequestFilterOfNiftyDescribePrivateLans, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeRouters(v *types.RequestFilterOfNiftyDescribeRouters, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeSeparateInstanceRules(v *types.RequestFilterOfNiftyDescribeSeparateInstanceRules, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestFilterOfNiftyDescribeWebProxies(v *types.RequestFilterOfNiftyDescribeWebProxies, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestValue != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentListOfRequestValue(v.ListOfRequestValue, objectKey); err != nil {
			return err
		}
	}

	if len(v.Name) > 0 {
		objectKey := object.Key("Name")
		objectKey.String(string(v.Name))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestGroups(v *types.RequestGroups, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestHealthCheck(v *types.RequestHealthCheck, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthyThreshold != nil {
		objectKey := object.Key("HealthyThreshold")
		objectKey.Integer(*v.HealthyThreshold)
	}

	if v.Interval != nil {
		objectKey := object.Key("Interval")
		objectKey.Integer(*v.Interval)
	}

	if v.Target != nil {
		objectKey := object.Key("Target")
		objectKey.String(*v.Target)
	}

	if v.Timeout != nil {
		objectKey := object.Key("Timeout")
		objectKey.Integer(*v.Timeout)
	}

	if v.UnhealthyThreshold != nil {
		objectKey := object.Key("UnhealthyThreshold")
		objectKey.Integer(*v.UnhealthyThreshold)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestHealthCheckOfNiftyConfigureElasticLoadBalancerHealthCheck(v *types.RequestHealthCheckOfNiftyConfigureElasticLoadBalancerHealthCheck, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Interval != nil {
		objectKey := object.Key("Interval")
		objectKey.Integer(*v.Interval)
	}

	if v.ListOfRequestExpectation != nil {
		objectKey := object.Key("Expectation")
		if err := awsEc2query_serializeDocumentListOfRequestExpectation(v.ListOfRequestExpectation, objectKey); err != nil {
			return err
		}
	}

	if v.Path != nil {
		objectKey := object.Key("Path")
		objectKey.String(*v.Path)
	}

	if v.Target != nil {
		objectKey := object.Key("Target")
		objectKey.String(*v.Target)
	}

	if v.UnhealthyThreshold != nil {
		objectKey := object.Key("UnhealthyThreshold")
		objectKey.Integer(*v.UnhealthyThreshold)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestHealthCheckOfNiftyCreateElasticLoadBalancer(v *types.RequestHealthCheckOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Interval != nil {
		objectKey := object.Key("Interval")
		objectKey.Integer(*v.Interval)
	}

	if v.ListOfRequestExpectation != nil {
		objectKey := object.Key("Expectation")
		if err := awsEc2query_serializeDocumentListOfRequestExpectationOfNiftyCreateElasticLoadBalancer(v.ListOfRequestExpectation, objectKey); err != nil {
			return err
		}
	}

	if v.Path != nil {
		objectKey := object.Key("Path")
		objectKey.String(*v.Path)
	}

	if v.Target != nil {
		objectKey := object.Key("Target")
		objectKey.String(*v.Target)
	}

	if v.UnhealthyThreshold != nil {
		objectKey := object.Key("UnhealthyThreshold")
		objectKey.Integer(*v.UnhealthyThreshold)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestImage(v *types.RequestImage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Bytes != nil {
		objectKey := object.Key("Bytes")
		objectKey.Integer(*v.Bytes)
	}

	if v.Format != nil {
		objectKey := object.Key("Format")
		objectKey.String(*v.Format)
	}

	if v.ImportManifestUrl != nil {
		objectKey := object.Key("ImportManifestUrl")
		objectKey.String(*v.ImportManifestUrl)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInboundInterface(v *types.RequestInboundInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstances(v *types.RequestInstances, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstancesOfDescribeInstanceHealth(v *types.RequestInstancesOfDescribeInstanceHealth, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstancesOfNiftyCreateElasticLoadBalancer(v *types.RequestInstancesOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer(v *types.RequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth(v *types.RequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer(v *types.RequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestIPAddresses(v *types.RequestIPAddresses, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddOnFilter != nil {
		objectKey := object.Key("AddOnFilter")
		objectKey.Boolean(*v.AddOnFilter)
	}

	if v.IPAddress != nil {
		objectKey := object.Key("IPAddress")
		objectKey.String(*v.IPAddress)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestIpPermissions(v *types.RequestIpPermissions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.FromPort != nil {
		objectKey := object.Key("FromPort")
		objectKey.Integer(*v.FromPort)
	}

	if len(v.InOut) > 0 {
		objectKey := object.Key("InOut")
		objectKey.String(string(v.InOut))
	}

	if len(v.IpProtocol) > 0 {
		objectKey := object.Key("IpProtocol")
		objectKey.String(string(v.IpProtocol))
	}

	if v.ListOfRequestGroups != nil {
		objectKey := object.FlatKey("Groups")
		if err := awsEc2query_serializeDocumentListOfRequestGroups(v.ListOfRequestGroups, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestIpRanges != nil {
		objectKey := object.FlatKey("IpRanges")
		if err := awsEc2query_serializeDocumentListOfRequestIpRanges(v.ListOfRequestIpRanges, objectKey); err != nil {
			return err
		}
	}

	if v.ToPort != nil {
		objectKey := object.Key("ToPort")
		objectKey.Integer(*v.ToPort)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestIpPermissionsOfRevokeSecurityGroupIngress(v *types.RequestIpPermissionsOfRevokeSecurityGroupIngress, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FromPort != nil {
		objectKey := object.Key("FromPort")
		objectKey.Integer(*v.FromPort)
	}

	if len(v.InOut) > 0 {
		objectKey := object.Key("InOut")
		objectKey.String(string(v.InOut))
	}

	if len(v.IpProtocol) > 0 {
		objectKey := object.Key("IpProtocol")
		objectKey.String(string(v.IpProtocol))
	}

	if v.ListOfRequestGroups != nil {
		objectKey := object.FlatKey("Groups")
		if err := awsEc2query_serializeDocumentListOfRequestGroups(v.ListOfRequestGroups, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestIpRanges != nil {
		objectKey := object.FlatKey("IpRanges")
		if err := awsEc2query_serializeDocumentListOfRequestIpRanges(v.ListOfRequestIpRanges, objectKey); err != nil {
			return err
		}
	}

	if v.ToPort != nil {
		objectKey := object.Key("ToPort")
		objectKey.Integer(*v.ToPort)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestIpRanges(v *types.RequestIpRanges, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CidrIp != nil {
		objectKey := object.Key("CidrIp")
		objectKey.String(*v.CidrIp)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLaunchPermission(v *types.RequestLaunchPermission, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestAdd != nil {
		objectKey := object.FlatKey("Add")
		if err := awsEc2query_serializeDocumentListOfRequestAdd(v.ListOfRequestAdd, objectKey); err != nil {
			return err
		}
	}

	if v.ListOfRequestRemove != nil {
		objectKey := object.FlatKey("Remove")
		if err := awsEc2query_serializeDocumentListOfRequestRemove(v.ListOfRequestRemove, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLicense(v *types.RequestLicense, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.LicenseName) > 0 {
		objectKey := object.Key("LicenseName")
		objectKey.String(string(v.LicenseName))
	}

	if v.LicenseNum != nil {
		objectKey := object.Key("LicenseNum")
		objectKey.String(*v.LicenseNum)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListener(v *types.RequestListener, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BalancingType != nil {
		objectKey := object.Key("BalancingType")
		objectKey.Integer(*v.BalancingType)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListeners(v *types.RequestListeners, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BalancingType != nil {
		objectKey := object.Key("BalancingType")
		objectKey.Integer(*v.BalancingType)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListenersOfNiftyCreateElasticLoadBalancer(v *types.RequestListenersOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BalancingType != nil {
		objectKey := object.Key("BalancingType")
		objectKey.Integer(*v.BalancingType)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.ListOfRequestInstances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyCreateElasticLoadBalancer(v.ListOfRequestInstances, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.RequestHealthCheck != nil {
		objectKey := object.Key("HealthCheck")
		if err := awsEc2query_serializeDocumentRequestHealthCheckOfNiftyCreateElasticLoadBalancer(v.RequestHealthCheck, objectKey); err != nil {
			return err
		}
	}

	if v.RequestSession != nil {
		objectKey := object.Key("Session")
		if err := awsEc2query_serializeDocumentRequestSession(v.RequestSession, objectKey); err != nil {
			return err
		}
	}

	if v.RequestSorryPage != nil {
		objectKey := object.Key("SorryPage")
		if err := awsEc2query_serializeDocumentRequestSorryPage(v.RequestSorryPage, objectKey); err != nil {
			return err
		}
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListenersOfNiftyRegisterPortWithElasticLoadBalancer(v *types.RequestListenersOfNiftyRegisterPortWithElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BalancingType != nil {
		objectKey := object.Key("BalancingType")
		objectKey.Integer(*v.BalancingType)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListenersOfRegisterPortWithLoadBalancer(v *types.RequestListenersOfRegisterPortWithLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BalancingType != nil {
		objectKey := object.Key("BalancingType")
		objectKey.Integer(*v.BalancingType)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListenerUpdate(v *types.RequestListenerUpdate, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.RequestListener != nil {
		objectKey := object.Key("Listener")
		if err := awsEc2query_serializeDocumentRequestListener(v.RequestListener, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestListenInterface(v *types.RequestListenInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLoadBalancerAttributes(v *types.RequestLoadBalancerAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestAdditionalAttributes != nil {
		objectKey := object.Key("AdditionalAttributes")
		if err := awsEc2query_serializeDocumentListOfRequestAdditionalAttributes(v.ListOfRequestAdditionalAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.RequestSession != nil {
		objectKey := object.Key("Session")
		if err := awsEc2query_serializeDocumentRequestSessionOfNiftyModifyElasticLoadBalancerAttributes(v.RequestSession, objectKey); err != nil {
			return err
		}
	}

	if v.RequestSorryPage != nil {
		objectKey := object.Key("SorryPage")
		if err := awsEc2query_serializeDocumentRequestSorryPage(v.RequestSorryPage, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLoadBalancerNames(v *types.RequestLoadBalancerNames, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLoadBalancers(v *types.RequestLoadBalancers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLoadBalancersOfNiftyCreateAutoScalingGroup(v *types.RequestLoadBalancersOfNiftyCreateAutoScalingGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestLoadBalancersOfNiftyUpdateAutoScalingGroup(v *types.RequestLoadBalancersOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestMonitoring(v *types.RequestMonitoring, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(*v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestMonitoringOfImportInstance(v *types.RequestMonitoringOfImportInstance, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled != nil {
		objectKey := object.Key("Enabled")
		objectKey.String(*v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestMonth(v *types.RequestMonth, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndingMonth != nil {
		objectKey := object.Key("EndingMonth")
		objectKey.String(*v.EndingMonth)
	}

	if v.StartingMonth != nil {
		objectKey := object.Key("StartingMonth")
		objectKey.String(*v.StartingMonth)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterface(v *types.RequestNetworkInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceIndex != nil {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(*v.DeviceIndex)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.ListOfRequestSecurityGroupId != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroupId(v.ListOfRequestSecurityGroupId, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfCopyFromBackupInstance(v *types.RequestNetworkInterfaceOfCopyFromBackupInstance, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfCreateRemoteAccessVpnGateway(v *types.RequestNetworkInterfaceOfCreateRemoteAccessVpnGateway, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfCreateVpnGateway(v *types.RequestNetworkInterfaceOfCreateVpnGateway, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.IsOutsideNetwork != nil {
		objectKey := object.Key("IsOutsideNetwork")
		objectKey.Boolean(*v.IsOutsideNetwork)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer(v *types.RequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.IsVipNetwork != nil {
		objectKey := object.Key("IsVipNetwork")
		objectKey.Boolean(*v.IsVipNetwork)
	}

	if v.ListOfRequestSystemIpAddresses != nil {
		objectKey := object.FlatKey("SystemIpAddresses")
		if err := awsEc2query_serializeDocumentListOfRequestSystemIpAddresses(v.ListOfRequestSystemIpAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyCreateRouter(v *types.RequestNetworkInterfaceOfNiftyCreateRouter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceIndex != nil {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(*v.DeviceIndex)
	}

	if v.Dhcp != nil {
		objectKey := object.Key("Dhcp")
		objectKey.Boolean(*v.Dhcp)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.DhcpOptionsId != nil {
		objectKey := object.Key("DhcpOptionsId")
		objectKey.String(*v.DhcpOptionsId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.ListOfRequestSecurityGroupId != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroupId(v.ListOfRequestSecurityGroupId, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion(v *types.RequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ListOfRequestSystemIpAddresses != nil {
		objectKey := object.FlatKey("SystemIpAddresses")
		if err := awsEc2query_serializeDocumentListOfRequestSystemIpAddresses(v.ListOfRequestSystemIpAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces(v *types.RequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceIndex != nil {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(*v.DeviceIndex)
	}

	if v.Dhcp != nil {
		objectKey := object.Key("Dhcp")
		objectKey.Boolean(*v.Dhcp)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.DhcpOptionsId != nil {
		objectKey := object.Key("DhcpOptionsId")
		objectKey.String(*v.DhcpOptionsId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.ListOfRequestSecurityGroupId != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroupId(v.ListOfRequestSecurityGroupId, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces(v *types.RequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.IsOutsideNetwork != nil {
		objectKey := object.Key("IsOutsideNetwork")
		objectKey.Boolean(*v.IsOutsideNetwork)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNiftyIpsecConfiguration(v *types.RequestNiftyIpsecConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DiffieHellmanGroup != nil {
		objectKey := object.Key("DiffieHellmanGroup")
		objectKey.Integer(*v.DiffieHellmanGroup)
	}

	if v.EncapsulatingSecurityPayloadLifetime != nil {
		objectKey := object.Key("EncapsulatingSecurityPayloadLifetime")
		objectKey.Integer(*v.EncapsulatingSecurityPayloadLifetime)
	}

	if len(v.EncryptionAlgorithm) > 0 {
		objectKey := object.Key("EncryptionAlgorithm")
		objectKey.String(string(v.EncryptionAlgorithm))
	}

	if len(v.HashAlgorithm) > 0 {
		objectKey := object.Key("HashAlgorithm")
		objectKey.String(string(v.HashAlgorithm))
	}

	if len(v.InternetKeyExchange) > 0 {
		objectKey := object.Key("InternetKeyExchange")
		objectKey.String(string(v.InternetKeyExchange))
	}

	if v.InternetKeyExchangeLifetime != nil {
		objectKey := object.Key("InternetKeyExchangeLifetime")
		objectKey.Integer(*v.InternetKeyExchangeLifetime)
	}

	if v.PreSharedKey != nil {
		objectKey := object.Key("PreSharedKey")
		objectKey.String(*v.PreSharedKey)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNiftyNetwork(v *types.RequestNiftyNetwork, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestNiftyTunnel(v *types.RequestNiftyTunnel, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DestinationPort != nil {
		objectKey := object.Key("DestinationPort")
		objectKey.String(*v.DestinationPort)
	}

	if len(v.Encapsulation) > 0 {
		objectKey := object.Key("Encapsulation")
		objectKey.String(string(v.Encapsulation))
	}

	if len(v.Mode) > 0 {
		objectKey := object.Key("Mode")
		objectKey.String(string(v.Mode))
	}

	if v.PeerSessionId != nil {
		objectKey := object.Key("PeerSessionId")
		objectKey.String(*v.PeerSessionId)
	}

	if v.PeerTunnelId != nil {
		objectKey := object.Key("PeerTunnelId")
		objectKey.String(*v.PeerTunnelId)
	}

	if v.SessionId != nil {
		objectKey := object.Key("SessionId")
		objectKey.String(*v.SessionId)
	}

	if v.SourcePort != nil {
		objectKey := object.Key("SourcePort")
		objectKey.String(*v.SourcePort)
	}

	if v.TunnelId != nil {
		objectKey := object.Key("TunnelId")
		objectKey.String(*v.TunnelId)
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestOption(v *types.RequestOption, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NameServer != nil {
		objectKey := object.Key("NameServer")
		objectKey.String(*v.NameServer)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestOutboundInterface(v *types.RequestOutboundInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacement(v *types.RequestPlacement, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfAllocateAddress(v *types.RequestPlacementOfAllocateAddress, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCopyInstances(v *types.RequestPlacementOfCopyInstances, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.RegionName != nil {
		objectKey := object.Key("RegionName")
		objectKey.String(*v.RegionName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateImage(v *types.RequestPlacementOfCreateImage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.RegionName != nil {
		objectKey := object.Key("RegionName")
		objectKey.String(*v.RegionName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateMultiIpAddressGroup(v *types.RequestPlacementOfCreateMultiIpAddressGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateNetworkInterface(v *types.RequestPlacementOfCreateNetworkInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateRemoteAccessVpnGateway(v *types.RequestPlacementOfCreateRemoteAccessVpnGateway, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateSecurityGroup(v *types.RequestPlacementOfCreateSecurityGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfCreateVpnGateway(v *types.RequestPlacementOfCreateVpnGateway, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfImportInstance(v *types.RequestPlacementOfImportInstance, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestPlacementOfNiftyCreateSeparateInstanceRule(v *types.RequestPlacementOfNiftyCreateSeparateInstanceRule, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRange(v *types.RequestRange, value query.Value) error {
	object := value.Object()
	_ = object

	if v.All != nil {
		objectKey := object.Key("All")
		objectKey.Boolean(*v.All)
	}

	if v.EndNumber != nil {
		objectKey := object.Key("EndNumber")
		objectKey.Integer(*v.EndNumber)
	}

	if v.StartNumber != nil {
		objectKey := object.Key("StartNumber")
		objectKey.Integer(*v.StartNumber)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRangeOfDescribeUserActivities(v *types.RequestRangeOfDescribeUserActivities, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndNumber != nil {
		objectKey := object.Key("EndNumber")
		objectKey.Integer(*v.EndNumber)
	}

	if v.StartNumber != nil {
		objectKey := object.Key("StartNumber")
		objectKey.Integer(*v.StartNumber)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRemoteUser(v *types.RequestRemoteUser, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Password != nil {
		objectKey := object.Key("Password")
		objectKey.String(*v.Password)
	}

	if v.UserName != nil {
		objectKey := object.Key("UserName")
		objectKey.String(*v.UserName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers(v *types.RequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.UserName != nil {
		objectKey := object.Key("UserName")
		objectKey.String(*v.UserName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRemove(v *types.RequestRemove, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Group != nil {
		objectKey := object.Key("Group")
		objectKey.String(*v.Group)
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRouter(v *types.RequestRouter, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRouterSet(v *types.RequestRouterSet, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRule(v *types.RequestRule, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BreachDuration != nil {
		objectKey := object.Key("BreachDuration")
		objectKey.Integer(*v.BreachDuration)
	}

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.Threshold != nil {
		objectKey := object.Key("Threshold")
		switch {
		case math.IsNaN(*v.Threshold):
			objectKey.String("NaN")

		case math.IsInf(*v.Threshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Threshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Threshold)

		}
	}

	if len(v.UpperLowerCondition) > 0 {
		objectKey := object.Key("UpperLowerCondition")
		objectKey.String(string(v.UpperLowerCondition))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarmHistory(v *types.RequestRuleOfNiftyDescribeAlarmHistory, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FromDate != nil {
		objectKey := object.Key("FromDate")
		objectKey.String(*v.FromDate)
	}

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.ToDate != nil {
		objectKey := object.Key("ToDate")
		objectKey.String(*v.ToDate)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarmRulesActivities(v *types.RequestRuleOfNiftyDescribeAlarmRulesActivities, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.FromDate != nil {
		objectKey := object.Key("FromDate")
		objectKey.String(*v.FromDate)
	}

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.ToDate != nil {
		objectKey := object.Key("ToDate")
		objectKey.String(*v.ToDate)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRuleOfNiftyDescribeAlarms(v *types.RequestRuleOfNiftyDescribeAlarms, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestRuleOfNiftyUpdateAlarm(v *types.RequestRuleOfNiftyUpdateAlarm, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BreachDuration != nil {
		objectKey := object.Key("BreachDuration")
		objectKey.Integer(*v.BreachDuration)
	}

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.Threshold != nil {
		objectKey := object.Key("Threshold")
		switch {
		case math.IsNaN(*v.Threshold):
			objectKey.String("NaN")

		case math.IsInf(*v.Threshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.Threshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.Threshold)

		}
	}

	if len(v.UpperLowerCondition) > 0 {
		objectKey := object.Key("UpperLowerCondition")
		objectKey.String(string(v.UpperLowerCondition))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestScalingSchedule(v *types.RequestScalingSchedule, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestDay != nil {
		objectKey := object.Key("Day")
		if err := awsEc2query_serializeDocumentRequestDay(v.RequestDay, objectKey); err != nil {
			return err
		}
	}

	if v.RequestDDay != nil {
		objectKey := object.Key("DDay")
		if err := awsEc2query_serializeDocumentRequestDDay(v.RequestDDay, objectKey); err != nil {
			return err
		}
	}

	if v.RequestMonth != nil {
		objectKey := object.Key("Month")
		if err := awsEc2query_serializeDocumentRequestMonth(v.RequestMonth, objectKey); err != nil {
			return err
		}
	}

	if v.RequestTimeZone != nil {
		objectKey := object.Key("TimeZone")
		if err := awsEc2query_serializeDocumentRequestTimeZone(v.RequestTimeZone, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestScalingScheduleOfNiftyUpdateAutoScalingGroup(v *types.RequestScalingScheduleOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestDay != nil {
		objectKey := object.Key("Day")
		if err := awsEc2query_serializeDocumentRequestDayOfNiftyUpdateAutoScalingGroup(v.RequestDay, objectKey); err != nil {
			return err
		}
	}

	if v.RequestDDay != nil {
		objectKey := object.Key("DDay")
		if err := awsEc2query_serializeDocumentRequestDDay(v.RequestDDay, objectKey); err != nil {
			return err
		}
	}

	if v.RequestMonth != nil {
		objectKey := object.Key("Month")
		if err := awsEc2query_serializeDocumentRequestMonth(v.RequestMonth, objectKey); err != nil {
			return err
		}
	}

	if v.RequestTimeZone != nil {
		objectKey := object.Key("TimeZone")
		if err := awsEc2query_serializeDocumentRequestTimeZone(v.RequestTimeZone, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestScalingTrigger(v *types.RequestScalingTrigger, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BreachDuration != nil {
		objectKey := object.Key("BreachDuration")
		objectKey.Integer(*v.BreachDuration)
	}

	if len(v.Resource) > 0 {
		objectKey := object.Key("Resource")
		objectKey.String(string(v.Resource))
	}

	if v.UpperThreshold != nil {
		objectKey := object.Key("UpperThreshold")
		switch {
		case math.IsNaN(*v.UpperThreshold):
			objectKey.String("NaN")

		case math.IsInf(*v.UpperThreshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.UpperThreshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.UpperThreshold)

		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestScalingTriggerOfNiftyUpdateAutoScalingGroup(v *types.RequestScalingTriggerOfNiftyUpdateAutoScalingGroup, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BreachDuration != nil {
		objectKey := object.Key("BreachDuration")
		objectKey.Integer(*v.BreachDuration)
	}

	if len(v.Resource) > 0 {
		objectKey := object.Key("Resource")
		objectKey.String(string(v.Resource))
	}

	if v.UpperThreshold != nil {
		objectKey := object.Key("UpperThreshold")
		switch {
		case math.IsNaN(*v.UpperThreshold):
			objectKey.String("NaN")

		case math.IsInf(*v.UpperThreshold, 1):
			objectKey.String("Infinity")

		case math.IsInf(*v.UpperThreshold, -1):
			objectKey.String("-Infinity")

		default:
			objectKey.Double(*v.UpperThreshold)

		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSession(v *types.RequestSession, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestStickinessPolicy != nil {
		objectKey := object.Key("StickinessPolicy")
		if err := awsEc2query_serializeDocumentRequestStickinessPolicy(v.RequestStickinessPolicy, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSessionOfNiftyModifyElasticLoadBalancerAttributes(v *types.RequestSessionOfNiftyModifyElasticLoadBalancerAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RequestStickinessPolicy != nil {
		objectKey := object.Key("StickinessPolicy")
		if err := awsEc2query_serializeDocumentRequestStickinessPolicyOfNiftyModifyElasticLoadBalancerAttributes(v.RequestStickinessPolicy, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSessionStickinessPolicyUpdate(v *types.RequestSessionStickinessPolicyUpdate, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.ExpirationPeriod != nil {
		objectKey := object.Key("ExpirationPeriod")
		objectKey.Integer(*v.ExpirationPeriod)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSorryPage(v *types.RequestSorryPage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.RedirectUrl != nil {
		objectKey := object.Key("RedirectUrl")
		objectKey.String(*v.RedirectUrl)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSorryPageUpdate(v *types.RequestSorryPageUpdate, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.StatusCode != nil {
		objectKey := object.Key("StatusCode")
		objectKey.Integer(*v.StatusCode)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSource(v *types.RequestSource, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Address != nil {
		objectKey := object.Key("Address")
		objectKey.String(*v.Address)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestStickinessPolicy(v *types.RequestStickinessPolicy, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.ExpirationPeriod != nil {
		objectKey := object.Key("ExpirationPeriod")
		objectKey.Integer(*v.ExpirationPeriod)
	}

	if len(v.Method) > 0 {
		objectKey := object.Key("Method")
		objectKey.String(string(v.Method))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestStickinessPolicyOfNiftyModifyElasticLoadBalancerAttributes(v *types.RequestStickinessPolicyOfNiftyModifyElasticLoadBalancerAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enable != nil {
		objectKey := object.Key("Enable")
		objectKey.Boolean(*v.Enable)
	}

	if v.ExpirationPeriod != nil {
		objectKey := object.Key("ExpirationPeriod")
		objectKey.Integer(*v.ExpirationPeriod)
	}

	if len(v.Method) > 0 {
		objectKey := object.Key("Method")
		objectKey.String(string(v.Method))
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSystemIpAddresses(v *types.RequestSystemIpAddresses, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SystemIpAddress != nil {
		objectKey := object.Key("SystemIpAddress")
		objectKey.String(*v.SystemIpAddress)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestTimeZone(v *types.RequestTimeZone, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EndingTimeZone != nil {
		objectKey := object.Key("EndingTimeZone")
		objectKey.String(*v.EndingTimeZone)
	}

	if v.StartingTimeZone != nil {
		objectKey := object.Key("StartingTimeZone")
		objectKey.String(*v.StartingTimeZone)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestTranslation(v *types.RequestTranslation, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Address != nil {
		objectKey := object.Key("Address")
		objectKey.String(*v.Address)
	}

	if v.Port != nil {
		objectKey := object.Key("Port")
		objectKey.Integer(*v.Port)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestUserData(v *types.RequestUserData, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Content != nil {
		objectKey := object.Key("Content")
		objectKey.String(*v.Content)
	}

	if v.Encoding != nil {
		objectKey := object.Key("Encoding")
		objectKey.String(*v.Encoding)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestUserDataOfImportInstance(v *types.RequestUserDataOfImportInstance, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Content != nil {
		objectKey := object.Key("Content")
		objectKey.String(*v.Content)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestUsers(v *types.RequestUsers, value query.Value) error {
	object := value.Object()
	_ = object

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestVolume(v *types.RequestVolume, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Size != nil {
		objectKey := object.Key("Size")
		objectKey.Integer(*v.Size)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestVpnGateway(v *types.RequestVpnGateway, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestVpnGatewaySet(v *types.RequestVpnGatewaySet, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentAllocateAddressInput(v *AllocateAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Domain != nil {
		objectKey := object.Key("Domain")
		objectKey.String(*v.Domain)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.NiftyPrivateIp != nil {
		objectKey := object.Key("NiftyPrivateIp")
		objectKey.Boolean(*v.NiftyPrivateIp)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfAllocateAddress(v.Placement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentAssociateAddressInput(v *AssociateAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllocationId != nil {
		objectKey := object.Key("AllocationId")
		objectKey.String(*v.AllocationId)
	}

	if v.AllowReassociation != nil {
		objectKey := object.Key("AllowReassociation")
		objectKey.Boolean(*v.AllowReassociation)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	return nil
}

func awsEc2query_serializeOpDocumentAssociateMultiIpAddressGroupInput(v *AssociateMultiIpAddressGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	return nil
}

func awsEc2query_serializeOpDocumentAssociateRouteTableInput(v *AssociateRouteTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentAssociateUsersInput(v *AssociateUsersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.Users != nil {
		objectKey := object.Key("Users")
		if err := awsEc2query_serializeDocumentListOfRequestUsers(v.Users, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentAttachIsoImageInput(v *AttachIsoImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.IsoImageId != nil {
		objectKey := object.Key("IsoImageId")
		objectKey.String(*v.IsoImageId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentAttachNetworkInterfaceInput(v *AttachNetworkInterfaceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	return nil
}

func awsEc2query_serializeOpDocumentAttachVolumeInput(v *AttachVolumeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Device != nil {
		objectKey := object.Key("Device")
		objectKey.String(*v.Device)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentAuthorizeSecurityGroupIngressInput(v *AuthorizeSecurityGroupIngressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.IpPermissions != nil {
		objectKey := object.FlatKey("IpPermissions")
		if err := awsEc2query_serializeDocumentListOfRequestIpPermissions(v.IpPermissions, objectKey); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCancelCopyInstancesInput(v *CancelCopyInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCancelUploadInput(v *CancelUploadInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConversionTaskId != nil {
		objectKey := object.Key("ConversionTaskId")
		objectKey.String(*v.ConversionTaskId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentClearLoadBalancerSessionInput(v *ClearLoadBalancerSessionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentConfigureHealthCheckInput(v *ConfigureHealthCheckInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthCheck != nil {
		objectKey := object.Key("HealthCheck")
		if err := awsEc2query_serializeDocumentRequestHealthCheck(v.HealthCheck, objectKey); err != nil {
			return err
		}
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCopyFromBackupInstanceInput(v *CopyFromBackupInstanceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.BackupInstanceUniqueId != nil {
		objectKey := object.Key("BackupInstanceUniqueId")
		objectKey.String(*v.BackupInstanceUniqueId)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DisableApiTermination != nil {
		objectKey := object.Key("DisableApiTermination")
		objectKey.Boolean(*v.DisableApiTermination)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCopyFromBackupInstance(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCopyInstancesInput(v *CopyInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CopyCount != nil {
		objectKey := object.Key("CopyCount")
		objectKey.Integer(*v.CopyCount)
	}

	if v.CopyInstance != nil {
		objectKey := object.Key("CopyInstance")
		if err := awsEc2query_serializeDocumentRequestCopyInstance(v.CopyInstance, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterface(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateBackupInstancesInput(v *CreateBackupInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceBackupRuleId != nil {
		objectKey := object.Key("InstanceBackupRuleId")
		objectKey.String(*v.InstanceBackupRuleId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateCustomerGatewayInput(v *CreateCustomerGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BgpAsn != nil {
		objectKey := object.Key("BgpAsn")
		objectKey.Integer(*v.BgpAsn)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NiftyCustomerGatewayDescription != nil {
		objectKey := object.Key("NiftyCustomerGatewayDescription")
		objectKey.String(*v.NiftyCustomerGatewayDescription)
	}

	if v.NiftyCustomerGatewayName != nil {
		objectKey := object.Key("NiftyCustomerGatewayName")
		objectKey.String(*v.NiftyCustomerGatewayName)
	}

	if v.NiftyLanSideCidrBlock != nil {
		objectKey := object.Key("NiftyLanSideCidrBlock")
		objectKey.String(*v.NiftyLanSideCidrBlock)
	}

	if v.NiftyLanSideIpAddress != nil {
		objectKey := object.Key("NiftyLanSideIpAddress")
		objectKey.String(*v.NiftyLanSideIpAddress)
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateDhcpOptionsInput(v *CreateDhcpOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpConfiguration != nil {
		objectKey := object.FlatKey("DhcpConfiguration")
		if err := awsEc2query_serializeDocumentListOfRequestDhcpConfiguration(v.DhcpConfiguration, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateImageOperationInput(v *CreateImageOperationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.LeftInstance != nil {
		objectKey := object.Key("LeftInstance")
		objectKey.Boolean(*v.LeftInstance)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.NoReboot != nil {
		objectKey := object.Key("NoReboot")
		objectKey.Boolean(*v.NoReboot)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateImage(v.Placement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateInstanceBackupRuleInput(v *CreateInstanceBackupRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BackupInstanceMaxCount != nil {
		objectKey := object.Key("BackupInstanceMaxCount")
		objectKey.Integer(*v.BackupInstanceMaxCount)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.InstanceBackupRuleName != nil {
		objectKey := object.Key("InstanceBackupRuleName")
		objectKey.String(*v.InstanceBackupRuleName)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.FlatKey("InstanceUniqueId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceUniqueId(v.InstanceUniqueId, objectKey); err != nil {
			return err
		}
	}

	if len(v.TimeSlotId) > 0 {
		objectKey := object.Key("TimeSlotId")
		objectKey.String(string(v.TimeSlotId))
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateKeyPairInput(v *CreateKeyPairInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.Password != nil {
		objectKey := object.Key("Password")
		objectKey.String(*v.Password)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateLoadBalancerInput(v *CreateLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsEc2query_serializeDocumentListOfRequestAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if len(v.IpVersion) > 0 {
		objectKey := object.Key("IpVersion")
		objectKey.String(string(v.IpVersion))
	}

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsEc2query_serializeDocumentListOfRequestListeners(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.NetworkVolume != nil {
		objectKey := object.Key("NetworkVolume")
		objectKey.Integer(*v.NetworkVolume)
	}

	if len(v.PolicyType) > 0 {
		objectKey := object.Key("PolicyType")
		objectKey.String(string(v.PolicyType))
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateMultiIpAddressGroupInput(v *CreateMultiIpAddressGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.IpAddressCount != nil {
		objectKey := object.Key("IpAddressCount")
		objectKey.Integer(*v.IpAddressCount)
	}

	if v.MultiIpAddressGroupName != nil {
		objectKey := object.Key("MultiIpAddressGroupName")
		objectKey.String(*v.MultiIpAddressGroupName)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateMultiIpAddressGroup(v.Placement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateNetworkInterfaceInput(v *CreateNetworkInterfaceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NiftyNetworkId != nil {
		objectKey := object.Key("NiftyNetworkId")
		objectKey.String(*v.NiftyNetworkId)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateNetworkInterface(v.Placement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateRemoteAccessVpnGatewayInput(v *CreateRemoteAccessVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountingType != nil {
		objectKey := object.Key("AccountingType")
		objectKey.Integer(*v.AccountingType)
	}

	if v.CACertificateId != nil {
		objectKey := object.Key("CACertificateId")
		objectKey.String(*v.CACertificateId)
	}

	if v.CipherSuite != nil {
		objectKey := object.FlatKey("CipherSuite")
		if err := awsEc2query_serializeDocumentListOfRequestCipherSuite(v.CipherSuite, objectKey); err != nil {
			return err
		}
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCreateRemoteAccessVpnGateway(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateRemoteAccessVpnGateway(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.PoolNetworkCidr != nil {
		objectKey := object.Key("PoolNetworkCidr")
		objectKey.String(*v.PoolNetworkCidr)
	}

	if v.RemoteAccessVpnGatewayName != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayName")
		objectKey.String(*v.RemoteAccessVpnGatewayName)
	}

	if len(v.RemoteAccessVpnGatewayType) > 0 {
		objectKey := object.Key("RemoteAccessVpnGatewayType")
		objectKey.String(string(v.RemoteAccessVpnGatewayType))
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateRemoteAccessVpnGatewayUsersInput(v *CreateRemoteAccessVpnGatewayUsersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	if v.RemoteUser != nil {
		objectKey := object.FlatKey("RemoteUser")
		if err := awsEc2query_serializeDocumentListOfRequestRemoteUser(v.RemoteUser, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateRouteInput(v *CreateRouteInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DestinationCidrBlock != nil {
		objectKey := object.Key("DestinationCidrBlock")
		objectKey.String(*v.DestinationCidrBlock)
	}

	if v.GatewayId != nil {
		objectKey := object.Key("GatewayId")
		objectKey.String(*v.GatewayId)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	if v.VpcPeeringConnectionId != nil {
		objectKey := object.Key("VpcPeeringConnectionId")
		objectKey.String(*v.VpcPeeringConnectionId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateRouteTableInput(v *CreateRouteTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.VpcId != nil {
		objectKey := object.Key("VpcId")
		objectKey.String(*v.VpcId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateSecurityGroupInput(v *CreateSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupDescription != nil {
		objectKey := object.Key("GroupDescription")
		objectKey.String(*v.GroupDescription)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateSecurityGroup(v.Placement, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateSslCertificateInput(v *CreateSslCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ApproverEmailAddress != nil {
		objectKey := object.Key("ApproverEmailAddress")
		objectKey.String(*v.ApproverEmailAddress)
	}

	if v.CertAuthority != nil {
		objectKey := object.Key("CertAuthority")
		objectKey.Integer(*v.CertAuthority)
	}

	if v.CertInfo != nil {
		objectKey := object.Key("CertInfo")
		if err := awsEc2query_serializeDocumentRequestCertInfo(v.CertInfo, objectKey); err != nil {
			return err
		}
	}

	if v.Count != nil {
		objectKey := object.Key("Count")
		objectKey.Integer(*v.Count)
	}

	if v.Fqdn != nil {
		objectKey := object.Key("Fqdn")
		objectKey.String(*v.Fqdn)
	}

	if v.FqdnId != nil {
		objectKey := object.Key("FqdnId")
		objectKey.String(*v.FqdnId)
	}

	if v.KeyLength != nil {
		objectKey := object.Key("KeyLength")
		objectKey.Integer(*v.KeyLength)
	}

	if v.ValidityTerm != nil {
		objectKey := object.Key("ValidityTerm")
		objectKey.Integer(*v.ValidityTerm)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateVolumeInput(v *CreateVolumeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DiskType != nil {
		objectKey := object.Key("DiskType")
		objectKey.String(*v.DiskType)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.Size != nil {
		objectKey := object.Key("Size")
		objectKey.Integer(*v.Size)
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateVpnConnectionInput(v *CreateVpnConnectionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.CustomerGatewayId != nil {
		objectKey := object.Key("CustomerGatewayId")
		objectKey.String(*v.CustomerGatewayId)
	}

	if v.NiftyCustomerGatewayName != nil {
		objectKey := object.Key("NiftyCustomerGatewayName")
		objectKey.String(*v.NiftyCustomerGatewayName)
	}

	if v.NiftyIpsecConfiguration != nil {
		objectKey := object.Key("NiftyIpsecConfiguration")
		if err := awsEc2query_serializeDocumentRequestNiftyIpsecConfiguration(v.NiftyIpsecConfiguration, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyTunnel != nil {
		objectKey := object.Key("NiftyTunnel")
		if err := awsEc2query_serializeDocumentRequestNiftyTunnel(v.NiftyTunnel, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyVpnConnectionDescription != nil {
		objectKey := object.Key("NiftyVpnConnectionDescription")
		objectKey.String(*v.NiftyVpnConnectionDescription)
	}

	if v.NiftyVpnConnectionMtu != nil {
		objectKey := object.Key("NiftyVpnConnectionMtu")
		objectKey.String(*v.NiftyVpnConnectionMtu)
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentCreateVpnGatewayInput(v *CreateVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfCreateVpnGateway(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyNetwork != nil {
		objectKey := object.Key("NiftyNetwork")
		if err := awsEc2query_serializeDocumentRequestNiftyNetwork(v.NiftyNetwork, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyRedundancy != nil {
		objectKey := object.Key("NiftyRedundancy")
		objectKey.Boolean(*v.NiftyRedundancy)
	}

	if v.NiftyVpnGatewayDescription != nil {
		objectKey := object.Key("NiftyVpnGatewayDescription")
		objectKey.String(*v.NiftyVpnGatewayDescription)
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if len(v.NiftyVpnGatewayType) > 0 {
		objectKey := object.Key("NiftyVpnGatewayType")
		objectKey.String(string(v.NiftyVpnGatewayType))
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfCreateVpnGateway(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	if v.Type != nil {
		objectKey := object.Key("Type")
		objectKey.String(*v.Type)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteCustomerGatewayInput(v *DeleteCustomerGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomerGatewayId != nil {
		objectKey := object.Key("CustomerGatewayId")
		objectKey.String(*v.CustomerGatewayId)
	}

	if v.NiftyCustomerGatewayName != nil {
		objectKey := object.Key("NiftyCustomerGatewayName")
		objectKey.String(*v.NiftyCustomerGatewayName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteDhcpOptionsInput(v *DeleteDhcpOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpOptionsId != nil {
		objectKey := object.Key("DhcpOptionsId")
		objectKey.String(*v.DhcpOptionsId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteImageInput(v *DeleteImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteInstanceBackupRuleInput(v *DeleteInstanceBackupRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceBackupRuleId != nil {
		objectKey := object.Key("InstanceBackupRuleId")
		objectKey.String(*v.InstanceBackupRuleId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteIsoImageInput(v *DeleteIsoImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IsoImageId != nil {
		objectKey := object.Key("IsoImageId")
		objectKey.String(*v.IsoImageId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteKeyPairInput(v *DeleteKeyPairInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteLoadBalancerInput(v *DeleteLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteMultiIpAddressGroupInput(v *DeleteMultiIpAddressGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteNetworkInterfaceInput(v *DeleteNetworkInterfaceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayConnectionsInput(v *DeleteRemoteAccessVpnGatewayConnectionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Connection != nil {
		objectKey := object.FlatKey("Connection")
		if err := awsEc2query_serializeDocumentListOfRequestConnection(v.Connection, objectKey); err != nil {
			return err
		}
	}

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayInput(v *DeleteRemoteAccessVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteRemoteAccessVpnGatewayUsersInput(v *DeleteRemoteAccessVpnGatewayUsersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	if v.RemoteUser != nil {
		objectKey := object.FlatKey("RemoteUser")
		if err := awsEc2query_serializeDocumentListOfRequestRemoteUserOfDeleteRemoteAccessVpnGatewayUsers(v.RemoteUser, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteRouteInput(v *DeleteRouteInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DestinationCidrBlock != nil {
		objectKey := object.Key("DestinationCidrBlock")
		objectKey.String(*v.DestinationCidrBlock)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteRouteTableInput(v *DeleteRouteTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteSecurityGroupInput(v *DeleteSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteSslCertificateInput(v *DeleteSslCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FqdnId != nil {
		objectKey := object.Key("FqdnId")
		objectKey.String(*v.FqdnId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteVolumeInput(v *DeleteVolumeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteVpnConnectionInput(v *DeleteVpnConnectionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.VpnConnectionId != nil {
		objectKey := object.Key("VpnConnectionId")
		objectKey.String(*v.VpnConnectionId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeleteVpnGatewayInput(v *DeleteVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeregisterInstancesFromLoadBalancerInput(v *DeregisterInstancesFromLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstances(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDeregisterInstancesFromSecurityGroupInput(v *DeregisterInstancesFromSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeAddressesInput(v *DescribeAddressesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllocationId != nil {
		objectKey := object.FlatKey("AllocationId")
		if err := awsEc2query_serializeDocumentListOfRequestAllocationId(v.AllocationId, objectKey); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeAddresses(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.FlatKey("PrivateIpAddress")
		if err := awsEc2query_serializeDocumentListOfRequestPrivateIpAddress(v.PrivateIpAddress, objectKey); err != nil {
			return err
		}
	}

	if v.PublicIp != nil {
		objectKey := object.FlatKey("PublicIp")
		if err := awsEc2query_serializeDocumentListOfRequestPublicIp(v.PublicIp, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeAssociatedUsersInput(v *DescribeAssociatedUsersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeAvailabilityZonesInput(v *DescribeAvailabilityZonesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ZoneName != nil {
		objectKey := object.FlatKey("ZoneName")
		if err := awsEc2query_serializeDocumentListOfRequestZoneName(v.ZoneName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeCustomerGatewaysInput(v *DescribeCustomerGatewaysInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomerGatewayId != nil {
		objectKey := object.FlatKey("CustomerGatewayId")
		if err := awsEc2query_serializeDocumentListOfRequestCustomerGatewayId(v.CustomerGatewayId, objectKey); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeCustomerGateways(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyCustomerGatewayName != nil {
		objectKey := object.FlatKey("NiftyCustomerGatewayName")
		if err := awsEc2query_serializeDocumentListOfRequestNiftyCustomerGatewayName(v.NiftyCustomerGatewayName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeDhcpOptionsInput(v *DescribeDhcpOptionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpOptionsId != nil {
		objectKey := object.FlatKey("DhcpOptionsId")
		if err := awsEc2query_serializeDocumentListOfRequestDhcpOptionsId(v.DhcpOptionsId, objectKey); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeDhcpOptions(v.Filter, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeImagesInput(v *DescribeImagesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ExecutableBy != nil {
		objectKey := object.FlatKey("ExecutableBy")
		if err := awsEc2query_serializeDocumentListOfRequestExecutableBy(v.ExecutableBy, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.FlatKey("ImageId")
		if err := awsEc2query_serializeDocumentListOfRequestImageId(v.ImageId, objectKey); err != nil {
			return err
		}
	}

	if v.ImageName != nil {
		objectKey := object.FlatKey("ImageName")
		if err := awsEc2query_serializeDocumentListOfRequestImageName(v.ImageName, objectKey); err != nil {
			return err
		}
	}

	if v.Owner != nil {
		objectKey := object.FlatKey("Owner")
		if err := awsEc2query_serializeDocumentListOfRequestOwner(v.Owner, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeInstanceAttributeInput(v *DescribeInstanceAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeInstanceBackupRuleActivitiesInput(v *DescribeInstanceBackupRuleActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Duration != nil {
		objectKey := object.Key("Duration")
		objectKey.Integer(*v.Duration)
	}

	if v.EndDateTime != nil {
		objectKey := object.Key("EndDateTime")
		objectKey.String(*v.EndDateTime)
	}

	if v.InstanceBackupRuleId != nil {
		objectKey := object.Key("InstanceBackupRuleId")
		objectKey.String(*v.InstanceBackupRuleId)
	}

	if v.MaxRecords != nil {
		objectKey := object.Key("MaxRecords")
		objectKey.Integer(*v.MaxRecords)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeInstanceBackupRulesInput(v *DescribeInstanceBackupRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceBackupRuleId != nil {
		objectKey := object.FlatKey("InstanceBackupRuleId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceBackupRuleId(v.InstanceBackupRuleId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeInstanceHealthInput(v *DescribeInstanceHealthInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfDescribeInstanceHealth(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeInstancesInput(v *DescribeInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.Tenancy != nil {
		objectKey := object.FlatKey("Tenancy")
		if err := awsEc2query_serializeDocumentListOfRequestTenancy(v.Tenancy, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeIsoImagesInput(v *DescribeIsoImagesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilter(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.IsoImageId != nil {
		objectKey := object.Key("IsoImageId")
		objectKey.String(*v.IsoImageId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeKeyPairsInput(v *DescribeKeyPairsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.KeyName != nil {
		objectKey := object.FlatKey("KeyName")
		if err := awsEc2query_serializeDocumentListOfRequestKeyName(v.KeyName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeLoadBalancersInput(v *DescribeLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := serializers.SerializeDocumentListOfRequestLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	if len(v.Owner) > 0 {
		objectKey := object.Key("Owner")
		objectKey.String(string(v.Owner))
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeMultiIpAddressGroupsInput(v *DescribeMultiIpAddressGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.FlatKey("MultiIpAddressGroupId")
		if err := awsEc2query_serializeDocumentListOfRequestMultiIpAddressGroupId(v.MultiIpAddressGroupId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeNetworkInterfacesInput(v *DescribeNetworkInterfacesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeNetworkInterfaces(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.FlatKey("NetworkInterfaceId")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceId(v.NetworkInterfaceId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRegionsInput(v *DescribeRegionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeRegions(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.RegionName != nil {
		objectKey := object.FlatKey("RegionName")
		if err := awsEc2query_serializeDocumentListOfRequestRegionName(v.RegionName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayActivitiesInput(v *DescribeRemoteAccessVpnGatewayActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayClientConfigInput(v *DescribeRemoteAccessVpnGatewayClientConfigInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewayConnectionsInput(v *DescribeRemoteAccessVpnGatewayConnectionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRemoteAccessVpnGatewaysInput(v *DescribeRemoteAccessVpnGatewaysInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.FlatKey("RemoteAccessVpnGatewayId")
		if err := awsEc2query_serializeDocumentListOfRequestRemoteAccessVpnGatewayId(v.RemoteAccessVpnGatewayId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeResourcesInput(v *DescribeResourcesInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsEc2query_serializeOpDocumentDescribeRouteTablesInput(v *DescribeRouteTablesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeRouteTables(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.RouteTableId != nil {
		objectKey := object.FlatKey("RouteTableId")
		if err := awsEc2query_serializeDocumentListOfRequestRouteTableId(v.RouteTableId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeSecurityActivitiesInput(v *DescribeSecurityActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActivityDate != nil {
		objectKey := object.Key("ActivityDate")
		objectKey.String(*v.ActivityDate)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.Range != nil {
		objectKey := object.Key("Range")
		if err := awsEc2query_serializeDocumentRequestRange(v.Range, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeSecurityGroupsInput(v *DescribeSecurityGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeSecurityGroups(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.GroupName != nil {
		objectKey := object.FlatKey("GroupName")
		if err := awsEc2query_serializeDocumentListOfRequestGroupName(v.GroupName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeServiceStatusInput(v *DescribeServiceStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FromDate != nil {
		objectKey := object.Key("FromDate")
		objectKey.String(*v.FromDate)
	}

	if v.ToDate != nil {
		objectKey := object.Key("ToDate")
		objectKey.String(*v.ToDate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeSslCertificateAttributeInput(v *DescribeSslCertificateAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.FqdnId != nil {
		objectKey := object.Key("FqdnId")
		objectKey.String(*v.FqdnId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeSslCertificatesInput(v *DescribeSslCertificatesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Fqdn != nil {
		objectKey := object.FlatKey("Fqdn")
		if err := awsEc2query_serializeDocumentListOfRequestFqdn(v.Fqdn, objectKey); err != nil {
			return err
		}
	}

	if v.FqdnId != nil {
		objectKey := object.FlatKey("FqdnId")
		if err := awsEc2query_serializeDocumentListOfRequestFqdnId(v.FqdnId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeUploadsInput(v *DescribeUploadsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ConversionTaskId != nil {
		objectKey := object.FlatKey("ConversionTaskId")
		if err := awsEc2query_serializeDocumentListOfRequestConversionTaskId(v.ConversionTaskId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeUsageInput(v *DescribeUsageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IsCharge != nil {
		objectKey := object.Key("IsCharge")
		objectKey.Boolean(*v.IsCharge)
	}

	if v.Region != nil {
		objectKey := object.Key("Region")
		objectKey.String(*v.Region)
	}

	if v.YearMonth != nil {
		objectKey := object.Key("YearMonth")
		objectKey.String(*v.YearMonth)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeUserActivitiesInput(v *DescribeUserActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Range != nil {
		objectKey := object.Key("Range")
		if err := awsEc2query_serializeDocumentRequestRangeOfDescribeUserActivities(v.Range, objectKey); err != nil {
			return err
		}
	}

	if v.YearMonth != nil {
		objectKey := object.Key("YearMonth")
		objectKey.String(*v.YearMonth)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeVolumesInput(v *DescribeVolumesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.VolumeId != nil {
		objectKey := object.FlatKey("VolumeId")
		if err := awsEc2query_serializeDocumentListOfRequestVolumeId(v.VolumeId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeVpnConnectionsInput(v *DescribeVpnConnectionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeVpnConnections(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.VpnConnectionId != nil {
		objectKey := object.FlatKey("VpnConnectionId")
		if err := awsEc2query_serializeDocumentListOfRequestVpnConnectionId(v.VpnConnectionId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDescribeVpnGatewaysInput(v *DescribeVpnGatewaysInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfDescribeVpnGateways(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.FlatKey("NiftyVpnGatewayName")
		if err := awsEc2query_serializeDocumentListOfRequestNiftyVpnGatewayName(v.NiftyVpnGatewayName, objectKey); err != nil {
			return err
		}
	}

	if v.VpnGatewayId != nil {
		objectKey := object.FlatKey("VpnGatewayId")
		if err := awsEc2query_serializeDocumentListOfRequestVpnGatewayId(v.VpnGatewayId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDetachIsoImageInput(v *DetachIsoImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.IsoImageId != nil {
		objectKey := object.Key("IsoImageId")
		objectKey.String(*v.IsoImageId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDetachNetworkInterfaceInput(v *DetachNetworkInterfaceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttachmentId != nil {
		objectKey := object.Key("AttachmentId")
		objectKey.String(*v.AttachmentId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	return nil
}

func awsEc2query_serializeOpDocumentDetachVolumeInput(v *DetachVolumeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.Device != nil {
		objectKey := object.Key("Device")
		objectKey.String(*v.Device)
	}

	if v.Force != nil {
		objectKey := object.Key("Force")
		objectKey.Boolean(*v.Force)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDisassociateAddressInput(v *DisassociateAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDisassociateMultiIpAddressGroupInput(v *DisassociateMultiIpAddressGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	return nil
}

func awsEc2query_serializeOpDocumentDisassociateRouteTableInput(v *DisassociateRouteTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentDissociateUsersInput(v *DissociateUsersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.Users != nil {
		objectKey := object.Key("Users")
		if err := awsEc2query_serializeDocumentListOfRequestUsers(v.Users, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentDownloadSslCertificateInput(v *DownloadSslCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FileType) > 0 {
		objectKey := object.Key("FileType")
		objectKey.String(string(v.FileType))
	}

	if v.FqdnId != nil {
		objectKey := object.Key("FqdnId")
		objectKey.String(*v.FqdnId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentExtendVolumeSizeInput(v *ExtendVolumeSizeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentImportInstanceOperationInput(v *ImportInstanceOperationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.Architecture != nil {
		objectKey := object.Key("Architecture")
		objectKey.String(*v.Architecture)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DiskImage != nil {
		objectKey := object.FlatKey("DiskImage")
		if err := awsEc2query_serializeDocumentListOfRequestDiskImage(v.DiskImage, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceInitiatedShutdownBehavior != nil {
		objectKey := object.Key("InstanceInitiatedShutdownBehavior")
		objectKey.String(*v.InstanceInitiatedShutdownBehavior)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if len(v.IpType) > 0 {
		objectKey := object.Key("IpType")
		objectKey.String(string(v.IpType))
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentRequestMonitoringOfImportInstance(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterface(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.Ovf != nil {
		objectKey := object.Key("Ovf")
		objectKey.String(*v.Ovf)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfImportInstance(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.Platform != nil {
		objectKey := object.Key("Platform")
		objectKey.String(*v.Platform)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		if err := awsEc2query_serializeDocumentRequestUserDataOfImportInstance(v.UserData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentImportKeyPairInput(v *ImportKeyPairInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.PublicKeyMaterial != nil {
		objectKey := object.Key("PublicKeyMaterial")
		objectKey.String(*v.PublicKeyMaterial)
	}

	return nil
}

func awsEc2query_serializeOpDocumentIncreaseMultiIpAddressCountInput(v *IncreaseMultiIpAddressCountInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddressCount != nil {
		objectKey := object.Key("IpAddressCount")
		objectKey.Integer(*v.IpAddressCount)
	}

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyImageAttributeInput(v *ModifyImageAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.LaunchPermission != nil {
		objectKey := object.Key("LaunchPermission")
		if err := awsEc2query_serializeDocumentRequestLaunchPermission(v.LaunchPermission, objectKey); err != nil {
			return err
		}
	}

	if v.ProductCode != nil {
		objectKey := object.FlatKey("ProductCode")
		if err := awsEc2query_serializeDocumentListOfRequestProductCode(v.ProductCode, objectKey); err != nil {
			return err
		}
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyInstanceAttributeInput(v *ModifyInstanceAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.Force != nil {
		objectKey := object.Key("Force")
		objectKey.Boolean(*v.Force)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if len(v.Tenancy) > 0 {
		objectKey := object.Key("Tenancy")
		objectKey.String(string(v.Tenancy))
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyInstanceBackupRuleAttributeInput(v *ModifyInstanceBackupRuleAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BackupInstanceMaxCount != nil {
		objectKey := object.Key("BackupInstanceMaxCount")
		objectKey.Integer(*v.BackupInstanceMaxCount)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.InstanceBackupRuleId != nil {
		objectKey := object.Key("InstanceBackupRuleId")
		objectKey.String(*v.InstanceBackupRuleId)
	}

	if v.InstanceBackupRuleName != nil {
		objectKey := object.Key("InstanceBackupRuleName")
		objectKey.String(*v.InstanceBackupRuleName)
	}

	if len(v.TimeSlotId) > 0 {
		objectKey := object.Key("TimeSlotId")
		objectKey.String(string(v.TimeSlotId))
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyMultiIpAddressGroupAttributeInput(v *ModifyMultiIpAddressGroupAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	if v.MultiIpAddressGroupName != nil {
		objectKey := object.Key("MultiIpAddressGroupName")
		objectKey.String(*v.MultiIpAddressGroupName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyNetworkInterfaceAttributeInput(v *ModifyNetworkInterfaceAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyRemoteAccessVpnGatewayAttributeInput(v *ModifyRemoteAccessVpnGatewayAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if len(v.ClientTunnelMode) > 0 {
		objectKey := object.Key("ClientTunnelMode")
		objectKey.String(string(v.ClientTunnelMode))
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	if v.RemoteAccessVpnGatewayName != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayName")
		objectKey.String(*v.RemoteAccessVpnGatewayName)
	}

	if len(v.RemoteAccessVpnGatewayType) > 0 {
		objectKey := object.Key("RemoteAccessVpnGatewayType")
		objectKey.String(string(v.RemoteAccessVpnGatewayType))
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyRemoteAccessVpnGatewayUserAttributeInput(v *ModifyRemoteAccessVpnGatewayUserAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Password != nil {
		objectKey := object.Key("Password")
		objectKey.String(*v.Password)
	}

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	if v.UserName != nil {
		objectKey := object.Key("UserName")
		objectKey.String(*v.UserName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifySslCertificateAttributeInput(v *ModifySslCertificateAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		if err := awsEc2query_serializeDocumentRequestDescription(v.Description, objectKey); err != nil {
			return err
		}
	}

	if v.FqdnId != nil {
		objectKey := object.Key("FqdnId")
		objectKey.String(*v.FqdnId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentModifyVolumeAttributeInput(v *ModifyVolumeAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyAssociateImageInput(v *NiftyAssociateImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DistributionId != nil {
		objectKey := object.FlatKey("DistributionId")
		if err := awsEc2query_serializeDocumentListOfRequestDistributionId(v.DistributionId, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.IsPublic != nil {
		objectKey := object.Key("IsPublic")
		objectKey.Boolean(*v.IsPublic)
	}

	if v.IsRedistribute != nil {
		objectKey := object.Key("IsRedistribute")
		objectKey.Boolean(*v.IsRedistribute)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyAssociateNatTableInput(v *NiftyAssociateNatTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyAssociateRouteTableWithElasticLoadBalancerInput(v *NiftyAssociateRouteTableWithElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyAssociateRouteTableWithVpnGatewayInput(v *NiftyAssociateRouteTableWithVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyConfigureElasticLoadBalancerHealthCheckInput(v *NiftyConfigureElasticLoadBalancerHealthCheckInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.HealthCheck != nil {
		objectKey := object.Key("HealthCheck")
		if err := awsEc2query_serializeDocumentRequestHealthCheckOfNiftyConfigureElasticLoadBalancerHealthCheck(v.HealthCheck, objectKey); err != nil {
			return err
		}
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateAlarmInput(v *NiftyCreateAlarmInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AlarmCondition) > 0 {
		objectKey := object.Key("AlarmCondition")
		objectKey.String(string(v.AlarmCondition))
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerName")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerName(v.ElasticLoadBalancerName, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerPort")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerPort(v.ElasticLoadBalancerPort, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticLoadBalancerProtocol != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerProtocol")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerProtocol(v.ElasticLoadBalancerProtocol, objectKey); err != nil {
			return err
		}
	}

	if v.EmailAddress != nil {
		objectKey := object.FlatKey("EmailAddress")
		if err := awsEc2query_serializeDocumentListOfRequestEmailAddress(v.EmailAddress, objectKey); err != nil {
			return err
		}
	}

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.FlatKey("LoadBalancerName")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancerName(v.LoadBalancerName, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.FlatKey("LoadBalancerPort")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancerPort(v.LoadBalancerPort, objectKey); err != nil {
			return err
		}
	}

	if v.Partition != nil {
		objectKey := object.FlatKey("Partition")
		if err := awsEc2query_serializeDocumentListOfRequestPartition(v.Partition, objectKey); err != nil {
			return err
		}
	}

	if v.Rule != nil {
		objectKey := object.FlatKey("Rule")
		if err := awsEc2query_serializeDocumentListOfRequestRule(v.Rule, objectKey); err != nil {
			return err
		}
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.Zone != nil {
		objectKey := object.Key("Zone")
		objectKey.String(*v.Zone)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateAutoScalingGroupInput(v *NiftyCreateAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.ChangeInCapacity != nil {
		objectKey := object.Key("ChangeInCapacity")
		objectKey.Integer(*v.ChangeInCapacity)
	}

	if v.DefaultCooldown != nil {
		objectKey := object.Key("DefaultCooldown")
		objectKey.Integer(*v.DefaultCooldown)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceLifecycleLimit != nil {
		objectKey := object.Key("InstanceLifecycleLimit")
		objectKey.Integer(*v.InstanceLifecycleLimit)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.LoadBalancers != nil {
		objectKey := object.FlatKey("LoadBalancers")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancersOfNiftyCreateAutoScalingGroup(v.LoadBalancers, objectKey); err != nil {
			return err
		}
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.Scaleout != nil {
		objectKey := object.Key("Scaleout")
		objectKey.Integer(*v.Scaleout)
	}

	if len(v.ScaleoutCondition) > 0 {
		objectKey := object.Key("ScaleoutCondition")
		objectKey.String(string(v.ScaleoutCondition))
	}

	if v.ScalingSchedule != nil {
		objectKey := object.FlatKey("ScalingSchedule")
		if err := awsEc2query_serializeDocumentListOfRequestScalingSchedule(v.ScalingSchedule, objectKey); err != nil {
			return err
		}
	}

	if v.ScalingTrigger != nil {
		objectKey := object.FlatKey("ScalingTrigger")
		if err := awsEc2query_serializeDocumentListOfRequestScalingTrigger(v.ScalingTrigger, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateDhcpConfigInput(v *NiftyCreateDhcpConfigInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateDhcpIpAddressPoolInput(v *NiftyCreateDhcpIpAddressPoolInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.StartIpAddress != nil {
		objectKey := object.Key("StartIpAddress")
		objectKey.String(*v.StartIpAddress)
	}

	if v.StopIpAddress != nil {
		objectKey := object.Key("StopIpAddress")
		objectKey.String(*v.StopIpAddress)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateDhcpStaticMappingInput(v *NiftyCreateDhcpStaticMappingInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.MacAddress != nil {
		objectKey := object.Key("MacAddress")
		objectKey.String(*v.MacAddress)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateElasticLoadBalancerInput(v *NiftyCreateElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsEc2query_serializeDocumentListOfRequestAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfNiftyCreateElasticLoadBalancer(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyCreateElasticLoadBalancer(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkVolume != nil {
		objectKey := object.Key("NetworkVolume")
		objectKey.Integer(*v.NetworkVolume)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateInstanceSnapshotInput(v *NiftyCreateInstanceSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.SnapshotName != nil {
		objectKey := object.Key("SnapshotName")
		objectKey.String(*v.SnapshotName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateNatRuleInput(v *NiftyCreateNatRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsEc2query_serializeDocumentRequestDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.InboundInterface != nil {
		objectKey := object.Key("InboundInterface")
		if err := awsEc2query_serializeDocumentRequestInboundInterface(v.InboundInterface, objectKey); err != nil {
			return err
		}
	}

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	if len(v.NatType) > 0 {
		objectKey := object.Key("NatType")
		objectKey.String(string(v.NatType))
	}

	if v.OutboundInterface != nil {
		objectKey := object.Key("OutboundInterface")
		if err := awsEc2query_serializeDocumentRequestOutboundInterface(v.OutboundInterface, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.RuleNumber != nil {
		objectKey := object.Key("RuleNumber")
		objectKey.String(*v.RuleNumber)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		if err := awsEc2query_serializeDocumentRequestSource(v.Source, objectKey); err != nil {
			return err
		}
	}

	if v.Translation != nil {
		objectKey := object.Key("Translation")
		if err := awsEc2query_serializeDocumentRequestTranslation(v.Translation, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateNatTableInput(v *NiftyCreateNatTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreatePrivateLanInput(v *NiftyCreatePrivateLanInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.CidrBlock != nil {
		objectKey := object.Key("CidrBlock")
		objectKey.String(*v.CidrBlock)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.PrivateLanName != nil {
		objectKey := object.Key("PrivateLanName")
		objectKey.String(*v.PrivateLanName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateRouterInput(v *NiftyCreateRouterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyCreateRouter(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateSeparateInstanceRuleInput(v *NiftyCreateSeparateInstanceRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.FlatKey("InstanceUniqueId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceUniqueId(v.InstanceUniqueId, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacementOfNiftyCreateSeparateInstanceRule(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.SeparateInstanceRuleDescription != nil {
		objectKey := object.Key("SeparateInstanceRuleDescription")
		objectKey.String(*v.SeparateInstanceRuleDescription)
	}

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.Key("SeparateInstanceRuleName")
		objectKey.String(*v.SeparateInstanceRuleName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyCreateWebProxyInput(v *NiftyCreateWebProxyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.BypassInterface != nil {
		objectKey := object.Key("BypassInterface")
		if err := awsEc2query_serializeDocumentRequestBypassInterface(v.BypassInterface, objectKey); err != nil {
			return err
		}
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ListenInterface != nil {
		objectKey := object.Key("ListenInterface")
		if err := awsEc2query_serializeDocumentRequestListenInterface(v.ListenInterface, objectKey); err != nil {
			return err
		}
	}

	if v.ListenPort != nil {
		objectKey := object.Key("ListenPort")
		objectKey.String(*v.ListenPort)
	}

	if v.Option != nil {
		objectKey := object.Key("Option")
		if err := awsEc2query_serializeDocumentRequestOption(v.Option, objectKey); err != nil {
			return err
		}
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteAlarmInput(v *NiftyDeleteAlarmInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteAutoScalingGroupInput(v *NiftyDeleteAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteDhcpConfigInput(v *NiftyDeleteDhcpConfigInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteDhcpIpAddressPoolInput(v *NiftyDeleteDhcpIpAddressPoolInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.StartIpAddress != nil {
		objectKey := object.Key("StartIpAddress")
		objectKey.String(*v.StartIpAddress)
	}

	if v.StopIpAddress != nil {
		objectKey := object.Key("StopIpAddress")
		objectKey.String(*v.StopIpAddress)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteDhcpStaticMappingInput(v *NiftyDeleteDhcpStaticMappingInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.MacAddress != nil {
		objectKey := object.Key("MacAddress")
		objectKey.String(*v.MacAddress)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteElasticLoadBalancerInput(v *NiftyDeleteElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteInstanceSnapshotInput(v *NiftyDeleteInstanceSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceSnapshotId != nil {
		objectKey := object.Key("InstanceSnapshotId")
		objectKey.String(*v.InstanceSnapshotId)
	}

	if v.SnapshotName != nil {
		objectKey := object.Key("SnapshotName")
		objectKey.String(*v.SnapshotName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteNatRuleInput(v *NiftyDeleteNatRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	if len(v.NatType) > 0 {
		objectKey := object.Key("NatType")
		objectKey.String(string(v.NatType))
	}

	if v.RuleNumber != nil {
		objectKey := object.Key("RuleNumber")
		objectKey.String(*v.RuleNumber)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteNatTableInput(v *NiftyDeleteNatTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeletePrivateLanInput(v *NiftyDeletePrivateLanInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.PrivateLanName != nil {
		objectKey := object.Key("PrivateLanName")
		objectKey.String(*v.PrivateLanName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteRouterInput(v *NiftyDeleteRouterInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteSeparateInstanceRuleInput(v *NiftyDeleteSeparateInstanceRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.Key("SeparateInstanceRuleName")
		objectKey.String(*v.SeparateInstanceRuleName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeleteWebProxyInput(v *NiftyDeleteWebProxyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeregisterInstancesFromElasticLoadBalancerInput(v *NiftyDeregisterInstancesFromElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDeregisterInstancesFromElasticLoadBalancer(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeregisterInstancesFromSeparateInstanceRuleInput(v *NiftyDeregisterInstancesFromSeparateInstanceRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.FlatKey("InstanceUniqueId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceUniqueId(v.InstanceUniqueId, objectKey); err != nil {
			return err
		}
	}

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.Key("SeparateInstanceRuleName")
		objectKey.String(*v.SeparateInstanceRuleName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeregisterRoutersFromSecurityGroupInput(v *NiftyDeregisterRoutersFromSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.RouterSet != nil {
		objectKey := object.FlatKey("RouterSet")
		if err := awsEc2query_serializeDocumentListOfRequestRouterSet(v.RouterSet, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDeregisterVpnGatewaysFromSecurityGroupInput(v *NiftyDeregisterVpnGatewaysFromSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.VpnGatewaySet != nil {
		objectKey := object.FlatKey("VpnGatewaySet")
		if err := awsEc2query_serializeDocumentListOfRequestVpnGatewaySet(v.VpnGatewaySet, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeAlarmHistoryInput(v *NiftyDescribeAlarmHistoryInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Rule != nil {
		objectKey := object.FlatKey("Rule")
		if err := awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarmHistory(v.Rule, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeAlarmRulesActivitiesInput(v *NiftyDescribeAlarmRulesActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Rule != nil {
		objectKey := object.FlatKey("Rule")
		if err := awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarmRulesActivities(v.Rule, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeAlarmsInput(v *NiftyDescribeAlarmsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Rule != nil {
		objectKey := object.FlatKey("Rule")
		if err := awsEc2query_serializeDocumentListOfRequestRuleOfNiftyDescribeAlarms(v.Rule, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeAlarmsPartitionsInput(v *NiftyDescribeAlarmsPartitionsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeAutoScalingGroupsInput(v *NiftyDescribeAutoScalingGroupsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.FlatKey("AutoScalingGroupName")
		if err := awsEc2query_serializeDocumentListOfRequestAutoScalingGroupName(v.AutoScalingGroupName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeCorporateInfoForCertificateInput(v *NiftyDescribeCorporateInfoForCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeDhcpConfigsInput(v *NiftyDescribeDhcpConfigsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DhcpConfigId != nil {
		objectKey := object.FlatKey("DhcpConfigId")
		if err := awsEc2query_serializeDocumentListOfRequestDhcpConfigId(v.DhcpConfigId, objectKey); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeDhcpConfigs(v.Filter, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeDhcpStatusInput(v *NiftyDescribeDhcpStatusInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeElasticLoadBalancersInput(v *NiftyDescribeElasticLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancers != nil {
		objectKey := object.Key("ElasticLoadBalancers")
		if err := awsEc2query_serializeDocumentRequestElasticLoadBalancers(v.ElasticLoadBalancers, objectKey); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeElasticLoadBalancers(v.Filter, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeInstanceElasticLoadBalancerHealthInput(v *NiftyDescribeInstanceElasticLoadBalancerHealthInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyDescribeInstanceElasticLoadBalancerHealth(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeInstanceSnapshotsInput(v *NiftyDescribeInstanceSnapshotsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceSnapshotId != nil {
		objectKey := object.FlatKey("InstanceSnapshotId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceSnapshotId(v.InstanceSnapshotId, objectKey); err != nil {
			return err
		}
	}

	if v.SnapshotName != nil {
		objectKey := object.FlatKey("SnapshotName")
		if err := awsEc2query_serializeDocumentListOfRequestSnapshotName(v.SnapshotName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeLoadBalancerSSLPoliciesInput(v *NiftyDescribeLoadBalancerSSLPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeNatTablesInput(v *NiftyDescribeNatTablesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeNatTables(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.NatTableId != nil {
		objectKey := object.FlatKey("NatTableId")
		if err := awsEc2query_serializeDocumentListOfRequestNatTableId(v.NatTableId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribePerformanceChartInput(v *NiftyDescribePerformanceChartInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DataType != nil {
		objectKey := object.FlatKey("DataType")
		if err := awsEc2query_serializeDocumentListOfRequestDataType(v.DataType, objectKey); err != nil {
			return err
		}
	}

	if v.FromDate != nil {
		objectKey := object.Key("FromDate")
		objectKey.String(*v.FromDate)
	}

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.ResourceName != nil {
		objectKey := object.FlatKey("ResourceName")
		if err := awsEc2query_serializeDocumentListOfRequestResourceName(v.ResourceName, objectKey); err != nil {
			return err
		}
	}

	if v.ToDate != nil {
		objectKey := object.Key("ToDate")
		objectKey.String(*v.ToDate)
	}

	if len(v.ValueType) > 0 {
		objectKey := object.Key("ValueType")
		objectKey.String(string(v.ValueType))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribePrivateLansInput(v *NiftyDescribePrivateLansInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribePrivateLans(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkId != nil {
		objectKey := object.FlatKey("NetworkId")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkId(v.NetworkId, objectKey); err != nil {
			return err
		}
	}

	if v.PrivateLanName != nil {
		objectKey := object.FlatKey("PrivateLanName")
		if err := awsEc2query_serializeDocumentListOfRequestPrivateLanName(v.PrivateLanName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeRoutersInput(v *NiftyDescribeRoutersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeRouters(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.RouterId != nil {
		objectKey := object.FlatKey("RouterId")
		if err := awsEc2query_serializeDocumentListOfRequestRouterId(v.RouterId, objectKey); err != nil {
			return err
		}
	}

	if v.RouterName != nil {
		objectKey := object.FlatKey("RouterName")
		if err := awsEc2query_serializeDocumentListOfRequestRouterName(v.RouterName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeScalingActivitiesInput(v *NiftyDescribeScalingActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActivityDateFrom != nil {
		objectKey := object.Key("ActivityDateFrom")
		objectKey.String(*v.ActivityDateFrom)
	}

	if v.ActivityDateTo != nil {
		objectKey := object.Key("ActivityDateTo")
		objectKey.String(*v.ActivityDateTo)
	}

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.Range != nil {
		objectKey := object.Key("Range")
		if err := awsEc2query_serializeDocumentRequestRange(v.Range, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeSeparateInstanceRulesInput(v *NiftyDescribeSeparateInstanceRulesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeSeparateInstanceRules(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.FlatKey("SeparateInstanceRuleName")
		if err := awsEc2query_serializeDocumentListOfRequestSeparateInstanceRuleName(v.SeparateInstanceRuleName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeVpnGatewayActivitiesInput(v *NiftyDescribeVpnGatewayActivitiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDescribeWebProxiesInput(v *NiftyDescribeWebProxiesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Filter != nil {
		objectKey := object.FlatKey("Filter")
		if err := awsEc2query_serializeDocumentListOfRequestFilterOfNiftyDescribeWebProxies(v.Filter, objectKey); err != nil {
			return err
		}
	}

	if v.RouterId != nil {
		objectKey := object.FlatKey("RouterId")
		if err := awsEc2query_serializeDocumentListOfRequestRouterId(v.RouterId, objectKey); err != nil {
			return err
		}
	}

	if v.RouterName != nil {
		objectKey := object.FlatKey("RouterName")
		if err := awsEc2query_serializeDocumentListOfRequestRouterName(v.RouterName, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDisableDhcpInput(v *NiftyDisableDhcpInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDisassociateNatTableInput(v *NiftyDisassociateNatTableInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDisassociateRouteTableFromElasticLoadBalancerInput(v *NiftyDisassociateRouteTableFromElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyDisassociateRouteTableFromVpnGatewayInput(v *NiftyDisassociateRouteTableFromVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyEnableDhcpInput(v *NiftyEnableDhcpInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.DhcpOptionsId != nil {
		objectKey := object.Key("DhcpOptionsId")
		objectKey.String(*v.DhcpOptionsId)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyAddressAttributeInput(v *NiftyModifyAddressAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyCustomerGatewayAttributeInput(v *NiftyModifyCustomerGatewayAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.CustomerGatewayId != nil {
		objectKey := object.Key("CustomerGatewayId")
		objectKey.String(*v.CustomerGatewayId)
	}

	if v.NiftyCustomerGatewayName != nil {
		objectKey := object.Key("NiftyCustomerGatewayName")
		objectKey.String(*v.NiftyCustomerGatewayName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyElasticLoadBalancerAttributesInput(v *NiftyModifyElasticLoadBalancerAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerAttributes != nil {
		objectKey := object.Key("LoadBalancerAttributes")
		if err := awsEc2query_serializeDocumentRequestLoadBalancerAttributes(v.LoadBalancerAttributes, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyInstanceSnapshotAttributeInput(v *NiftyModifyInstanceSnapshotAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.InstanceSnapshotId != nil {
		objectKey := object.Key("InstanceSnapshotId")
		objectKey.String(*v.InstanceSnapshotId)
	}

	if v.SnapshotName != nil {
		objectKey := object.Key("SnapshotName")
		objectKey.String(*v.SnapshotName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyKeyPairAttributeInput(v *NiftyModifyKeyPairAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyPrivateLanAttributeInput(v *NiftyModifyPrivateLanAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.PrivateLanName != nil {
		objectKey := object.Key("PrivateLanName")
		objectKey.String(*v.PrivateLanName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyRouterAttributeInput(v *NiftyModifyRouterAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyVpnGatewayAttributeInput(v *NiftyModifyVpnGatewayAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyModifyWebProxyAttributeInput(v *NiftyModifyWebProxyAttributeInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if len(v.Attribute) > 0 {
		objectKey := object.Key("Attribute")
		objectKey.String(string(v.Attribute))
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRebootRoutersInput(v *NiftyRebootRoutersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Router != nil {
		objectKey := object.FlatKey("Router")
		if err := awsEc2query_serializeDocumentListOfRequestRouter(v.Router, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRebootVpnGatewaysInput(v *NiftyRebootVpnGatewaysInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.VpnGateway != nil {
		objectKey := object.FlatKey("VpnGateway")
		if err := awsEc2query_serializeDocumentListOfRequestVpnGateway(v.VpnGateway, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRegisterInstancesWithElasticLoadBalancerInput(v *NiftyRegisterInstancesWithElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstancesOfNiftyRegisterInstancesWithElasticLoadBalancer(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRegisterInstancesWithSeparateInstanceRuleInput(v *NiftyRegisterInstancesWithSeparateInstanceRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.FlatKey("InstanceUniqueId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceUniqueId(v.InstanceUniqueId, objectKey); err != nil {
			return err
		}
	}

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.Key("SeparateInstanceRuleName")
		objectKey.String(*v.SeparateInstanceRuleName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRegisterPortWithElasticLoadBalancerInput(v *NiftyRegisterPortWithElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfNiftyRegisterPortWithElasticLoadBalancer(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRegisterRoutersWithSecurityGroupInput(v *NiftyRegisterRoutersWithSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.RouterSet != nil {
		objectKey := object.FlatKey("RouterSet")
		if err := awsEc2query_serializeDocumentListOfRequestRouterSet(v.RouterSet, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRegisterVpnGatewaysWithSecurityGroupInput(v *NiftyRegisterVpnGatewaysWithSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.VpnGatewaySet != nil {
		objectKey := object.FlatKey("VpnGatewaySet")
		if err := awsEc2query_serializeDocumentListOfRequestVpnGatewaySet(v.VpnGatewaySet, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReleaseRouterBackupStateInput(v *NiftyReleaseRouterBackupStateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReleaseVpnGatewayBackupStateInput(v *NiftyReleaseVpnGatewayBackupStateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceDhcpConfigInput(v *NiftyReplaceDhcpConfigInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.DhcpConfigId != nil {
		objectKey := object.Key("DhcpConfigId")
		objectKey.String(*v.DhcpConfigId)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceDhcpOptionInput(v *NiftyReplaceDhcpOptionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.DhcpOptionsId != nil {
		objectKey := object.Key("DhcpOptionsId")
		objectKey.String(*v.DhcpOptionsId)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceElasticLoadBalancerLatestVersionInput(v *NiftyReplaceElasticLoadBalancerLatestVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyReplaceElasticLoadBalancerLatestVersion(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceElasticLoadBalancerListenerSSLCertificateInput(v *NiftyReplaceElasticLoadBalancerListenerSSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.Key("ElasticLoadBalancerPort")
		objectKey.Integer(*v.ElasticLoadBalancerPort)
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceNatRuleInput(v *NiftyReplaceNatRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Destination != nil {
		objectKey := object.Key("Destination")
		if err := awsEc2query_serializeDocumentRequestDestination(v.Destination, objectKey); err != nil {
			return err
		}
	}

	if v.InboundInterface != nil {
		objectKey := object.Key("InboundInterface")
		if err := awsEc2query_serializeDocumentRequestInboundInterface(v.InboundInterface, objectKey); err != nil {
			return err
		}
	}

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	if len(v.NatType) > 0 {
		objectKey := object.Key("NatType")
		objectKey.String(string(v.NatType))
	}

	if v.OutboundInterface != nil {
		objectKey := object.Key("OutboundInterface")
		if err := awsEc2query_serializeDocumentRequestOutboundInterface(v.OutboundInterface, objectKey); err != nil {
			return err
		}
	}

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	if v.RuleNumber != nil {
		objectKey := object.Key("RuleNumber")
		objectKey.String(*v.RuleNumber)
	}

	if v.Source != nil {
		objectKey := object.Key("Source")
		if err := awsEc2query_serializeDocumentRequestSource(v.Source, objectKey); err != nil {
			return err
		}
	}

	if v.Translation != nil {
		objectKey := object.Key("Translation")
		if err := awsEc2query_serializeDocumentRequestTranslation(v.Translation, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceNatTableAssociationInput(v *NiftyReplaceNatTableAssociationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	if v.NatTableId != nil {
		objectKey := object.Key("NatTableId")
		objectKey.String(*v.NatTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceRouterLatestVersionInput(v *NiftyReplaceRouterLatestVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceRouteTableAssociationWithElasticLoadBalancerInput(v *NiftyReplaceRouteTableAssociationWithElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceRouteTableAssociationWithVpnGatewayInput(v *NiftyReplaceRouteTableAssociationWithVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyReplaceVpnGatewayLatestVersionInput(v *NiftyReplaceVpnGatewayLatestVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRestoreInstanceSnapshotInput(v *NiftyRestoreInstanceSnapshotInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceSnapshotId != nil {
		objectKey := object.Key("InstanceSnapshotId")
		objectKey.String(*v.InstanceSnapshotId)
	}

	if v.SnapshotName != nil {
		objectKey := object.Key("SnapshotName")
		objectKey.String(*v.SnapshotName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRestoreRouterPreviousVersionInput(v *NiftyRestoreRouterPreviousVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRestoreVpnGatewayPreviousVersionInput(v *NiftyRestoreVpnGatewayPreviousVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyRetryImportInstanceInput(v *NiftyRetryImportInstanceInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceUniqueId != nil {
		objectKey := object.Key("InstanceUniqueId")
		objectKey.String(*v.InstanceUniqueId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftySetLoadBalancerSSLPoliciesOfListenerInput(v *NiftySetLoadBalancerSSLPoliciesOfListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.SSLPolicyId != nil {
		objectKey := object.Key("SSLPolicyId")
		objectKey.String(*v.SSLPolicyId)
	}

	if v.SSLPolicyName != nil {
		objectKey := object.Key("SSLPolicyName")
		objectKey.String(*v.SSLPolicyName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUnsetLoadBalancerSSLPoliciesOfListenerInput(v *NiftyUnsetLoadBalancerSSLPoliciesOfListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateAlarmInput(v *NiftyUpdateAlarmInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AlarmCondition) > 0 {
		objectKey := object.Key("AlarmCondition")
		objectKey.String(string(v.AlarmCondition))
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerName")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerName(v.ElasticLoadBalancerName, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticLoadBalancerPort != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerPort")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerPort(v.ElasticLoadBalancerPort, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticLoadBalancerProtocol != nil {
		objectKey := object.FlatKey("ElasticLoadBalancerProtocol")
		if err := awsEc2query_serializeDocumentListOfRequestElasticLoadBalancerProtocol(v.ElasticLoadBalancerProtocol, objectKey); err != nil {
			return err
		}
	}

	if v.EmailAddress != nil {
		objectKey := object.FlatKey("EmailAddress")
		if err := awsEc2query_serializeDocumentListOfRequestEmailAddress(v.EmailAddress, objectKey); err != nil {
			return err
		}
	}

	if len(v.FunctionName) > 0 {
		objectKey := object.Key("FunctionName")
		objectKey.String(string(v.FunctionName))
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.FlatKey("LoadBalancerName")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancerName(v.LoadBalancerName, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.FlatKey("LoadBalancerPort")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancerPort(v.LoadBalancerPort, objectKey); err != nil {
			return err
		}
	}

	if v.Partition != nil {
		objectKey := object.FlatKey("Partition")
		if err := awsEc2query_serializeDocumentListOfRequestPartition(v.Partition, objectKey); err != nil {
			return err
		}
	}

	if v.Rule != nil {
		objectKey := object.FlatKey("Rule")
		if err := awsEc2query_serializeDocumentListOfRequestRuleOfNiftyUpdateAlarm(v.Rule, objectKey); err != nil {
			return err
		}
	}

	if v.RuleName != nil {
		objectKey := object.Key("RuleName")
		objectKey.String(*v.RuleName)
	}

	if v.RuleNameUpdate != nil {
		objectKey := object.Key("RuleNameUpdate")
		objectKey.String(*v.RuleNameUpdate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateAutoScalingGroupInput(v *NiftyUpdateAutoScalingGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AutoScalingGroupName != nil {
		objectKey := object.Key("AutoScalingGroupName")
		objectKey.String(*v.AutoScalingGroupName)
	}

	if v.AutoScalingGroupNameUpdate != nil {
		objectKey := object.Key("AutoScalingGroupNameUpdate")
		objectKey.String(*v.AutoScalingGroupNameUpdate)
	}

	if v.ChangeInCapacity != nil {
		objectKey := object.Key("ChangeInCapacity")
		objectKey.Integer(*v.ChangeInCapacity)
	}

	if v.DefaultCooldown != nil {
		objectKey := object.Key("DefaultCooldown")
		objectKey.Integer(*v.DefaultCooldown)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceLifecycleLimit != nil {
		objectKey := object.Key("InstanceLifecycleLimit")
		objectKey.Integer(*v.InstanceLifecycleLimit)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.LoadBalancers != nil {
		objectKey := object.FlatKey("LoadBalancers")
		if err := awsEc2query_serializeDocumentListOfRequestLoadBalancersOfNiftyUpdateAutoScalingGroup(v.LoadBalancers, objectKey); err != nil {
			return err
		}
	}

	if v.MaxSize != nil {
		objectKey := object.Key("MaxSize")
		objectKey.Integer(*v.MaxSize)
	}

	if v.MinSize != nil {
		objectKey := object.Key("MinSize")
		objectKey.Integer(*v.MinSize)
	}

	if v.Scaleout != nil {
		objectKey := object.Key("Scaleout")
		objectKey.Integer(*v.Scaleout)
	}

	if len(v.ScaleoutCondition) > 0 {
		objectKey := object.Key("ScaleoutCondition")
		objectKey.String(string(v.ScaleoutCondition))
	}

	if v.ScalingSchedule != nil {
		objectKey := object.FlatKey("ScalingSchedule")
		if err := awsEc2query_serializeDocumentListOfRequestScalingScheduleOfNiftyUpdateAutoScalingGroup(v.ScalingSchedule, objectKey); err != nil {
			return err
		}
	}

	if v.ScalingTrigger != nil {
		objectKey := object.FlatKey("ScalingTrigger")
		if err := awsEc2query_serializeDocumentListOfRequestScalingTriggerOfNiftyUpdateAutoScalingGroup(v.ScalingTrigger, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateElasticLoadBalancerInput(v *NiftyUpdateElasticLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountingTypeUpdate != nil {
		objectKey := object.Key("AccountingTypeUpdate")
		objectKey.Integer(*v.AccountingTypeUpdate)
	}

	if v.ElasticLoadBalancerId != nil {
		objectKey := object.Key("ElasticLoadBalancerId")
		objectKey.String(*v.ElasticLoadBalancerId)
	}

	if v.ElasticLoadBalancerName != nil {
		objectKey := object.Key("ElasticLoadBalancerName")
		objectKey.String(*v.ElasticLoadBalancerName)
	}

	if v.ElasticLoadBalancerNameUpdate != nil {
		objectKey := object.Key("ElasticLoadBalancerNameUpdate")
		objectKey.String(*v.ElasticLoadBalancerNameUpdate)
	}

	if v.NetworkVolumeUpdate != nil {
		objectKey := object.Key("NetworkVolumeUpdate")
		objectKey.Integer(*v.NetworkVolumeUpdate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateInstanceNetworkInterfacesInput(v *NiftyUpdateInstanceNetworkInterfacesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterface(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateRouterNetworkInterfacesInput(v *NiftyUpdateRouterNetworkInterfacesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyUpdateRouterNetworkInterfaces(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.RouterId != nil {
		objectKey := object.Key("RouterId")
		objectKey.String(*v.RouterId)
	}

	if v.RouterName != nil {
		objectKey := object.Key("RouterName")
		objectKey.String(*v.RouterName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateSeparateInstanceRuleInput(v *NiftyUpdateSeparateInstanceRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SeparateInstanceRuleDescriptionUpdate != nil {
		objectKey := object.Key("SeparateInstanceRuleDescriptionUpdate")
		objectKey.String(*v.SeparateInstanceRuleDescriptionUpdate)
	}

	if v.SeparateInstanceRuleName != nil {
		objectKey := object.Key("SeparateInstanceRuleName")
		objectKey.String(*v.SeparateInstanceRuleName)
	}

	if v.SeparateInstanceRuleNameUpdate != nil {
		objectKey := object.Key("SeparateInstanceRuleNameUpdate")
		objectKey.String(*v.SeparateInstanceRuleNameUpdate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentNiftyUpdateVpnGatewayNetworkInterfacesInput(v *NiftyUpdateVpnGatewayNetworkInterfacesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterfaceOfNiftyUpdateVpnGatewayNetworkInterfaces(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.NiftyVpnGatewayName != nil {
		objectKey := object.Key("NiftyVpnGatewayName")
		objectKey.String(*v.NiftyVpnGatewayName)
	}

	if v.VpnGatewayId != nil {
		objectKey := object.Key("VpnGatewayId")
		objectKey.String(*v.VpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRebootInstancesInput(v *RebootInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Force != nil {
		objectKey := object.Key("Force")
		objectKey.Boolean(*v.Force)
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyIsBios != nil {
		objectKey := object.Key("NiftyIsBios")
		objectKey.Boolean(*v.NiftyIsBios)
	}

	if v.Tenancy != nil {
		objectKey := object.FlatKey("Tenancy")
		if err := awsEc2query_serializeDocumentListOfRequestTenancy(v.Tenancy, objectKey); err != nil {
			return err
		}
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		if err := serializers.SerializeDocumentRequestUserData(v.UserData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentRebootRemoteAccessVpnGatewayInput(v *RebootRemoteAccessVpnGatewayInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.NiftyReboot) > 0 {
		objectKey := object.Key("NiftyReboot")
		objectKey.String(string(v.NiftyReboot))
	}

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRefreshInstanceBackupRuleInput(v *RefreshInstanceBackupRuleInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceBackupRuleId != nil {
		objectKey := object.Key("InstanceBackupRuleId")
		objectKey.String(*v.InstanceBackupRuleId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRegisterCorporateInfoForCertificateInput(v *RegisterCorporateInfoForCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AlphabetName1 != nil {
		objectKey := object.Key("AlphabetName1")
		objectKey.String(*v.AlphabetName1)
	}

	if v.AlphabetName2 != nil {
		objectKey := object.Key("AlphabetName2")
		objectKey.String(*v.AlphabetName2)
	}

	if v.City != nil {
		objectKey := object.Key("City")
		objectKey.String(*v.City)
	}

	if v.CorpGrade != nil {
		objectKey := object.Key("CorpGrade")
		objectKey.String(*v.CorpGrade)
	}

	if v.CorpName != nil {
		objectKey := object.Key("CorpName")
		objectKey.String(*v.CorpName)
	}

	if v.DivisionName != nil {
		objectKey := object.Key("DivisionName")
		objectKey.String(*v.DivisionName)
	}

	if v.EmailAddress != nil {
		objectKey := object.Key("EmailAddress")
		objectKey.String(*v.EmailAddress)
	}

	if v.KanaName1 != nil {
		objectKey := object.Key("KanaName1")
		objectKey.String(*v.KanaName1)
	}

	if v.KanaName2 != nil {
		objectKey := object.Key("KanaName2")
		objectKey.String(*v.KanaName2)
	}

	if v.Name1 != nil {
		objectKey := object.Key("Name1")
		objectKey.String(*v.Name1)
	}

	if v.Name2 != nil {
		objectKey := object.Key("Name2")
		objectKey.String(*v.Name2)
	}

	if v.PhoneNumber != nil {
		objectKey := object.Key("PhoneNumber")
		objectKey.String(*v.PhoneNumber)
	}

	if v.PostName != nil {
		objectKey := object.Key("PostName")
		objectKey.String(*v.PostName)
	}

	if v.Pref != nil {
		objectKey := object.Key("Pref")
		objectKey.String(*v.Pref)
	}

	if v.PresidentName1 != nil {
		objectKey := object.Key("PresidentName1")
		objectKey.String(*v.PresidentName1)
	}

	if v.PresidentName2 != nil {
		objectKey := object.Key("PresidentName2")
		objectKey.String(*v.PresidentName2)
	}

	if v.TdbCode != nil {
		objectKey := object.Key("TdbCode")
		objectKey.String(*v.TdbCode)
	}

	if v.Zip1 != nil {
		objectKey := object.Key("Zip1")
		objectKey.String(*v.Zip1)
	}

	if v.Zip2 != nil {
		objectKey := object.Key("Zip2")
		objectKey.String(*v.Zip2)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRegisterInstancesWithLoadBalancerInput(v *RegisterInstancesWithLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsEc2query_serializeDocumentListOfRequestInstances(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRegisterInstancesWithSecurityGroupInput(v *RegisterInstancesWithSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentRegisterPortWithLoadBalancerInput(v *RegisterPortWithLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsEc2query_serializeDocumentListOfRequestListenersOfRegisterPortWithLoadBalancer(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsEc2query_serializeOpDocumentReleaseAddressInput(v *ReleaseAddressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllocationId != nil {
		objectKey := object.Key("AllocationId")
		objectKey.String(*v.AllocationId)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	return nil
}

func awsEc2query_serializeOpDocumentReleaseMultiIpAddressesInput(v *ReleaseMultiIpAddressesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IpAddress != nil {
		objectKey := object.FlatKey("IpAddress")
		if err := awsEc2query_serializeDocumentListOfRequestIpAddress(v.IpAddress, objectKey); err != nil {
			return err
		}
	}

	if v.MultiIpAddressGroupId != nil {
		objectKey := object.Key("MultiIpAddressGroupId")
		objectKey.String(*v.MultiIpAddressGroupId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentReplaceRemoteAccessVpnGatewayLatestVersionInput(v *ReplaceRemoteAccessVpnGatewayLatestVersionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentReplaceRouteInput(v *ReplaceRouteInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DestinationCidrBlock != nil {
		objectKey := object.Key("DestinationCidrBlock")
		objectKey.String(*v.DestinationCidrBlock)
	}

	if v.GatewayId != nil {
		objectKey := object.Key("GatewayId")
		objectKey.String(*v.GatewayId)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.IpAddress != nil {
		objectKey := object.Key("IpAddress")
		objectKey.String(*v.IpAddress)
	}

	if v.NetworkId != nil {
		objectKey := object.Key("NetworkId")
		objectKey.String(*v.NetworkId)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if v.NetworkName != nil {
		objectKey := object.Key("NetworkName")
		objectKey.String(*v.NetworkName)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	if v.VpcPeeringConnectionId != nil {
		objectKey := object.Key("VpcPeeringConnectionId")
		objectKey.String(*v.VpcPeeringConnectionId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentReplaceRouteTableAssociationInput(v *ReplaceRouteTableAssociationInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.AssociationId != nil {
		objectKey := object.Key("AssociationId")
		objectKey.String(*v.AssociationId)
	}

	if v.RouteTableId != nil {
		objectKey := object.Key("RouteTableId")
		objectKey.String(*v.RouteTableId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRevokeSecurityGroupIngressInput(v *RevokeSecurityGroupIngressInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.IpPermissions != nil {
		objectKey := object.FlatKey("IpPermissions")
		if err := awsEc2query_serializeDocumentListOfRequestIpPermissionsOfRevokeSecurityGroupIngress(v.IpPermissions, objectKey); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentRunInstancesInput(v *RunInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AccountingType) > 0 {
		objectKey := object.Key("AccountingType")
		objectKey.String(string(v.AccountingType))
	}

	if v.AddressingType != nil {
		objectKey := object.Key("AddressingType")
		objectKey.String(*v.AddressingType)
	}

	if v.Admin != nil {
		objectKey := object.Key("Admin")
		objectKey.String(*v.Admin)
	}

	if v.Agreement != nil {
		objectKey := object.Key("Agreement")
		objectKey.Boolean(*v.Agreement)
	}

	if v.BlockDeviceMapping != nil {
		objectKey := object.FlatKey("BlockDeviceMapping")
		if err := awsEc2query_serializeDocumentListOfRequestBlockDeviceMapping(v.BlockDeviceMapping, objectKey); err != nil {
			return err
		}
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DisableApiTermination != nil {
		objectKey := object.Key("DisableApiTermination")
		objectKey.Boolean(*v.DisableApiTermination)
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	if v.InstanceInitiatedShutdownBehavior != nil {
		objectKey := object.Key("InstanceInitiatedShutdownBehavior")
		objectKey.String(*v.InstanceInitiatedShutdownBehavior)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if len(v.IpType) > 0 {
		objectKey := object.Key("IpType")
		objectKey.String(string(v.IpType))
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.License != nil {
		objectKey := object.FlatKey("License")
		if err := awsEc2query_serializeDocumentListOfRequestLicense(v.License, objectKey); err != nil {
			return err
		}
	}

	if v.MaxCount != nil {
		objectKey := object.Key("MaxCount")
		objectKey.Integer(*v.MaxCount)
	}

	if v.MinCount != nil {
		objectKey := object.Key("MinCount")
		objectKey.Integer(*v.MinCount)
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentRequestMonitoring(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterface != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentListOfRequestNetworkInterface(v.NetworkInterface, objectKey); err != nil {
			return err
		}
	}

	if v.Password != nil {
		objectKey := object.Key("Password")
		objectKey.String(*v.Password)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentRequestPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.PublicIp != nil {
		objectKey := object.Key("PublicIp")
		objectKey.String(*v.PublicIp)
	}

	if v.RamdiskId != nil {
		objectKey := object.Key("RamdiskId")
		objectKey.String(*v.RamdiskId)
	}

	if v.SecurityGroup != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentListOfRequestSecurityGroup(v.SecurityGroup, objectKey); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		if err := serializers.SerializeDocumentRequestUserData(v.UserData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentSetFilterForLoadBalancerInput(v *SetFilterForLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.FilterType) > 0 {
		objectKey := object.Key("FilterType")
		objectKey.String(string(v.FilterType))
	}

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.IPAddresses != nil {
		objectKey := object.Key("IPAddresses")
		if err := awsEc2query_serializeDocumentListOfRequestIPAddresses(v.IPAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentSetLoadBalancerListenerSSLCertificateInput(v *SetLoadBalancerListenerSSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentSetRemoteAccessVpnGatewayCACertificateInput(v *SetRemoteAccessVpnGatewayCACertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CACertificateId != nil {
		objectKey := object.Key("CACertificateId")
		objectKey.String(*v.CACertificateId)
	}

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentSetRemoteAccessVpnGatewaySSLCertificateInput(v *SetRemoteAccessVpnGatewaySSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentStartInstancesInput(v *StartInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountingType != nil {
		objectKey := object.FlatKey("AccountingType")
		if err := awsEc2query_serializeDocumentListOfRequestAccountingType(v.AccountingType, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		objectKey := object.FlatKey("InstanceType")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceType(v.InstanceType, objectKey); err != nil {
			return err
		}
	}

	if v.NiftyIsBios != nil {
		objectKey := object.Key("NiftyIsBios")
		objectKey.Boolean(*v.NiftyIsBios)
	}

	if v.Tenancy != nil {
		objectKey := object.FlatKey("Tenancy")
		if err := awsEc2query_serializeDocumentListOfRequestTenancy(v.Tenancy, objectKey); err != nil {
			return err
		}
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		if err := serializers.SerializeDocumentRequestUserData(v.UserData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentStopInstancesInput(v *StopInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Force != nil {
		objectKey := object.Key("Force")
		objectKey.Boolean(*v.Force)
	}

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	if v.Tenancy != nil {
		objectKey := object.FlatKey("Tenancy")
		if err := awsEc2query_serializeDocumentListOfRequestTenancy(v.Tenancy, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentTerminateInstancesInput(v *TerminateInstancesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.FlatKey("InstanceId")
		if err := awsEc2query_serializeDocumentListOfRequestInstanceId(v.InstanceId, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentUnsetLoadBalancerListenerSSLCertificateInput(v *UnsetLoadBalancerListenerSSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUnsetRemoteAccessVpnGatewayCACertificateInput(v *UnsetRemoteAccessVpnGatewayCACertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUnsetRemoteAccessVpnGatewaySSLCertificateInput(v *UnsetRemoteAccessVpnGatewaySSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.RemoteAccessVpnGatewayId != nil {
		objectKey := object.Key("RemoteAccessVpnGatewayId")
		objectKey.String(*v.RemoteAccessVpnGatewayId)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUpdateLoadBalancerInput(v *UpdateLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccountingTypeUpdate != nil {
		objectKey := object.Key("AccountingTypeUpdate")
		objectKey.Integer(*v.AccountingTypeUpdate)
	}

	if v.ListenerUpdate != nil {
		objectKey := object.Key("ListenerUpdate")
		if err := awsEc2query_serializeDocumentRequestListenerUpdate(v.ListenerUpdate, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerNameUpdate != nil {
		objectKey := object.Key("LoadBalancerNameUpdate")
		objectKey.String(*v.LoadBalancerNameUpdate)
	}

	if v.NetworkVolumeUpdate != nil {
		objectKey := object.Key("NetworkVolumeUpdate")
		objectKey.Integer(*v.NetworkVolumeUpdate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUpdateLoadBalancerOptionInput(v *UpdateLoadBalancerOptionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPort != nil {
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(*v.LoadBalancerPort)
	}

	if v.SessionStickinessPolicyUpdate != nil {
		objectKey := object.Key("SessionStickinessPolicyUpdate")
		if err := awsEc2query_serializeDocumentRequestSessionStickinessPolicyUpdate(v.SessionStickinessPolicyUpdate, objectKey); err != nil {
			return err
		}
	}

	if v.SorryPageUpdate != nil {
		objectKey := object.Key("SorryPageUpdate")
		if err := awsEc2query_serializeDocumentRequestSorryPageUpdate(v.SorryPageUpdate, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeOpDocumentUpdateSecurityGroupInput(v *UpdateSecurityGroupInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupDescriptionUpdate != nil {
		objectKey := object.Key("GroupDescriptionUpdate")
		objectKey.String(*v.GroupDescriptionUpdate)
	}

	if v.GroupLogFilterBroadcast != nil {
		objectKey := object.Key("GroupLogFilterBroadcast")
		objectKey.Boolean(*v.GroupLogFilterBroadcast)
	}

	if v.GroupLogFilterNetBios != nil {
		objectKey := object.Key("GroupLogFilterNetBios")
		objectKey.Boolean(*v.GroupLogFilterNetBios)
	}

	if v.GroupLogLimitUpdate != nil {
		objectKey := object.Key("GroupLogLimitUpdate")
		objectKey.Integer(*v.GroupLogLimitUpdate)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.GroupNameUpdate != nil {
		objectKey := object.Key("GroupNameUpdate")
		objectKey.String(*v.GroupNameUpdate)
	}

	if v.GroupRuleLimitUpdate != nil {
		objectKey := object.Key("GroupRuleLimitUpdate")
		objectKey.Integer(*v.GroupRuleLimitUpdate)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUploadIsoImageInput(v *UploadIsoImageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.IsoImageName != nil {
		objectKey := object.Key("IsoImageName")
		objectKey.String(*v.IsoImageName)
	}

	if v.IsoUrl != nil {
		objectKey := object.Key("IsoUrl")
		objectKey.String(*v.IsoUrl)
	}

	return nil
}

func awsEc2query_serializeOpDocumentUploadSslCertificateInput(v *UploadSslCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Certificate != nil {
		objectKey := object.Key("Certificate")
		objectKey.String(*v.Certificate)
	}

	if v.CertificateAuthority != nil {
		objectKey := object.Key("Ca")
		objectKey.String(*v.CertificateAuthority)
	}

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	return nil
}
