// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) RunInstances(ctx context.Context, params *RunInstancesInput, optFns ...func(*Options)) (*RunInstancesOutput, error) {
	if params == nil {
		params = &RunInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RunInstances", params, optFns, c.addOperationRunInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RunInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RunInstancesInput struct {

	// This member is required.
	ImageId *string

	AccountingType types.AccountingTypeOfRunInstancesRequest

	AddressingType *string

	Admin *string

	Agreement *bool

	BlockDeviceMapping []types.RequestBlockDeviceMapping

	Description *string

	DisableApiTermination *bool

	InstanceId *string

	InstanceInitiatedShutdownBehavior *string

	InstanceType types.InstanceTypeOfRunInstancesRequest

	IpType types.IpTypeOfRunInstancesRequest

	KernelId *string

	KeyName *string

	License []types.RequestLicense

	MaxCount *int32

	MinCount *int32

	Monitoring *types.RequestMonitoring

	NetworkInterface []types.RequestNetworkInterface

	Password *string

	Placement *types.RequestPlacement

	PublicIp *string

	RamdiskId *string

	SecurityGroup []string

	SubnetId *string

	UserData *types.RequestUserData

	noSmithyDocumentSerde
}

type RunInstancesOutput struct {
	GroupSet []types.GroupSet

	InstancesSet []types.InstancesSetOfRunInstances

	OwnerId *string

	RequestId *string

	ReservationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRunInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpRunInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpRunInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpRunInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRunInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRunInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RunInstances",
	}
}
