// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyUpdateAlarm(ctx context.Context, params *NiftyUpdateAlarmInput, optFns ...func(*Options)) (*NiftyUpdateAlarmOutput, error) {
	if params == nil {
		params = &NiftyUpdateAlarmInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyUpdateAlarm", params, optFns, c.addOperationNiftyUpdateAlarmMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyUpdateAlarmOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyUpdateAlarmInput struct {

	// This member is required.
	FunctionName types.FunctionNameOfNiftyUpdateAlarmRequest

	// This member is required.
	Rule []types.RequestRuleOfNiftyUpdateAlarm

	// This member is required.
	RuleName *string

	AlarmCondition types.AlarmConditionOfNiftyUpdateAlarmRequest

	Description *string

	ElasticLoadBalancerName []string

	ElasticLoadBalancerPort []int32

	ElasticLoadBalancerProtocol []string

	EmailAddress []string

	InstanceId []string

	LoadBalancerName []string

	LoadBalancerPort []int32

	Partition []string

	RuleNameUpdate *string

	noSmithyDocumentSerde
}

type NiftyUpdateAlarmOutput struct {
	RequestId *string

	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyUpdateAlarmMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyUpdateAlarm{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyUpdateAlarm{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyUpdateAlarmValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyUpdateAlarm(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyUpdateAlarm(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyUpdateAlarm",
	}
}
