// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyRegisterInstancesWithSeparateInstanceRule(ctx context.Context, params *NiftyRegisterInstancesWithSeparateInstanceRuleInput, optFns ...func(*Options)) (*NiftyRegisterInstancesWithSeparateInstanceRuleOutput, error) {
	if params == nil {
		params = &NiftyRegisterInstancesWithSeparateInstanceRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyRegisterInstancesWithSeparateInstanceRule", params, optFns, c.addOperationNiftyRegisterInstancesWithSeparateInstanceRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyRegisterInstancesWithSeparateInstanceRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyRegisterInstancesWithSeparateInstanceRuleInput struct {

	// This member is required.
	SeparateInstanceRuleName *string

	InstanceId []string

	InstanceUniqueId []string

	noSmithyDocumentSerde
}

type NiftyRegisterInstancesWithSeparateInstanceRuleOutput struct {
	InstancesSet []types.InstancesSetOfNiftyRegisterInstancesWithSeparateInstanceRule

	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyRegisterInstancesWithSeparateInstanceRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyRegisterInstancesWithSeparateInstanceRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyRegisterInstancesWithSeparateInstanceRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyRegisterInstancesWithSeparateInstanceRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyRegisterInstancesWithSeparateInstanceRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyRegisterInstancesWithSeparateInstanceRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyRegisterInstancesWithSeparateInstanceRule",
	}
}
