// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) NiftyDescribeLoadBalancerSSLPolicies(ctx context.Context, params *NiftyDescribeLoadBalancerSSLPoliciesInput, optFns ...func(*Options)) (*NiftyDescribeLoadBalancerSSLPoliciesOutput, error) {
	if params == nil {
		params = &NiftyDescribeLoadBalancerSSLPoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyDescribeLoadBalancerSSLPolicies", params, optFns, c.addOperationNiftyDescribeLoadBalancerSSLPoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyDescribeLoadBalancerSSLPoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyDescribeLoadBalancerSSLPoliciesInput struct {

	// This member is required.
	LoadBalancerName *string

	noSmithyDocumentSerde
}

type NiftyDescribeLoadBalancerSSLPoliciesOutput struct {
	NiftyDescribeLoadBalancerSSLPoliciesResult *types.NiftyDescribeLoadBalancerSSLPoliciesResult

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyDescribeLoadBalancerSSLPoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyDescribeLoadBalancerSSLPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyDescribeLoadBalancerSSLPolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpNiftyDescribeLoadBalancerSSLPoliciesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyDescribeLoadBalancerSSLPolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opNiftyDescribeLoadBalancerSSLPolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyDescribeLoadBalancerSSLPolicies",
	}
}
