// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"github.com/jmespath/go-jmespath"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
	"strconv"
	"time"
)

func (c *Client) NiftyDescribeElasticLoadBalancers(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, optFns ...func(*Options)) (*NiftyDescribeElasticLoadBalancersOutput, error) {
	if params == nil {
		params = &NiftyDescribeElasticLoadBalancersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "NiftyDescribeElasticLoadBalancers", params, optFns, c.addOperationNiftyDescribeElasticLoadBalancersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*NiftyDescribeElasticLoadBalancersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type NiftyDescribeElasticLoadBalancersInput struct {
	ElasticLoadBalancers *types.RequestElasticLoadBalancers

	Filter []types.RequestFilterOfNiftyDescribeElasticLoadBalancers

	noSmithyDocumentSerde
}

type NiftyDescribeElasticLoadBalancersOutput struct {
	NiftyDescribeElasticLoadBalancersResult *types.NiftyDescribeElasticLoadBalancersResult

	ResponseMetadata *types.ResponseMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationNiftyDescribeElasticLoadBalancersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpNiftyDescribeElasticLoadBalancers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpNiftyDescribeElasticLoadBalancers{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opNiftyDescribeElasticLoadBalancers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// NiftyDescribeElasticLoadBalancersAPIClient is a client that implements the
// NiftyDescribeElasticLoadBalancers operation.
type NiftyDescribeElasticLoadBalancersAPIClient interface {
	NiftyDescribeElasticLoadBalancers(context.Context, *NiftyDescribeElasticLoadBalancersInput, ...func(*Options)) (*NiftyDescribeElasticLoadBalancersOutput, error)
}

var _ NiftyDescribeElasticLoadBalancersAPIClient = (*Client)(nil)

// ElasticLoadBalancerExistsWaiterOptions are waiter options for
// ElasticLoadBalancerExistsWaiter
type ElasticLoadBalancerExistsWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ElasticLoadBalancerExistsWaiter will use default minimum delay of 20 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ElasticLoadBalancerExistsWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *NiftyDescribeElasticLoadBalancersInput, *NiftyDescribeElasticLoadBalancersOutput, error) (bool, error)
}

// ElasticLoadBalancerExistsWaiter defines the waiters for
// ElasticLoadBalancerExists
type ElasticLoadBalancerExistsWaiter struct {
	client NiftyDescribeElasticLoadBalancersAPIClient

	options ElasticLoadBalancerExistsWaiterOptions
}

// NewElasticLoadBalancerExistsWaiter constructs a ElasticLoadBalancerExistsWaiter.
func NewElasticLoadBalancerExistsWaiter(client NiftyDescribeElasticLoadBalancersAPIClient, optFns ...func(*ElasticLoadBalancerExistsWaiterOptions)) *ElasticLoadBalancerExistsWaiter {
	options := ElasticLoadBalancerExistsWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = elasticLoadBalancerExistsStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ElasticLoadBalancerExistsWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ElasticLoadBalancerExists waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ElasticLoadBalancerExistsWaiter) Wait(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerExistsWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ElasticLoadBalancerExists waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ElasticLoadBalancerExistsWaiter) WaitForOutput(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerExistsWaiterOptions)) (*NiftyDescribeElasticLoadBalancersOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.NiftyDescribeElasticLoadBalancers(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ElasticLoadBalancerExists waiter")
}

func elasticLoadBalancerExistsStateRetryable(ctx context.Context, input *NiftyDescribeElasticLoadBalancersInput, output *NiftyDescribeElasticLoadBalancersOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("length(NiftyDescribeElasticLoadBalancersResult.ElasticLoadBalancerDescriptions[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.ElasticLoadBalancer" == apiErr.ErrorCode() {
			return true, nil
		}
	}

	return true, nil
}

// ElasticLoadBalancerAvailableWaiterOptions are waiter options for
// ElasticLoadBalancerAvailableWaiter
type ElasticLoadBalancerAvailableWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ElasticLoadBalancerAvailableWaiter will use default minimum delay of 20 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ElasticLoadBalancerAvailableWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *NiftyDescribeElasticLoadBalancersInput, *NiftyDescribeElasticLoadBalancersOutput, error) (bool, error)
}

// ElasticLoadBalancerAvailableWaiter defines the waiters for
// ElasticLoadBalancerAvailable
type ElasticLoadBalancerAvailableWaiter struct {
	client NiftyDescribeElasticLoadBalancersAPIClient

	options ElasticLoadBalancerAvailableWaiterOptions
}

// NewElasticLoadBalancerAvailableWaiter constructs a
// ElasticLoadBalancerAvailableWaiter.
func NewElasticLoadBalancerAvailableWaiter(client NiftyDescribeElasticLoadBalancersAPIClient, optFns ...func(*ElasticLoadBalancerAvailableWaiterOptions)) *ElasticLoadBalancerAvailableWaiter {
	options := ElasticLoadBalancerAvailableWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = elasticLoadBalancerAvailableStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ElasticLoadBalancerAvailableWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ElasticLoadBalancerAvailable waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ElasticLoadBalancerAvailableWaiter) Wait(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerAvailableWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ElasticLoadBalancerAvailable waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ElasticLoadBalancerAvailableWaiter) WaitForOutput(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerAvailableWaiterOptions)) (*NiftyDescribeElasticLoadBalancersOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.NiftyDescribeElasticLoadBalancers(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ElasticLoadBalancerAvailable waiter")
}

func elasticLoadBalancerAvailableStateRetryable(ctx context.Context, input *NiftyDescribeElasticLoadBalancersInput, output *NiftyDescribeElasticLoadBalancersOutput, err error) (bool, error) {

	if err == nil {
		pathValue, err := jmespath.Search("NiftyDescribeElasticLoadBalancersResult.ElasticLoadBalancerDescriptions[].State", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "available"
		var match = true
		listOfValues, ok := pathValue.([]interface{})
		if !ok {
			return false, fmt.Errorf("waiter comparator expected list got %T", pathValue)
		}

		if len(listOfValues) == 0 {
			match = false
		}
		for _, v := range listOfValues {
			value, ok := v.(*string)
			if !ok {
				return false, fmt.Errorf("waiter comparator expected *string value, got %T", pathValue)
			}

			if string(*value) != expectedValue {
				match = false
			}
		}

		if match {
			return false, nil
		}
	}

	return true, nil
}

// ElasticLoadBalancerDeletedWaiterOptions are waiter options for
// ElasticLoadBalancerDeletedWaiter
type ElasticLoadBalancerDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	APIOptions []func(*middleware.Stack) error

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ElasticLoadBalancerDeletedWaiter will use default minimum delay of 20 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ElasticLoadBalancerDeletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state. By
	// default service-modeled logic will populate this option. This option can thus be
	// used to define a custom waiter state with fall-back to service-modeled waiter
	// state mutators.The function returns an error in case of a failure state. In case
	// of retry state, this function returns a bool value of true and nil error, while
	// in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *NiftyDescribeElasticLoadBalancersInput, *NiftyDescribeElasticLoadBalancersOutput, error) (bool, error)
}

// ElasticLoadBalancerDeletedWaiter defines the waiters for
// ElasticLoadBalancerDeleted
type ElasticLoadBalancerDeletedWaiter struct {
	client NiftyDescribeElasticLoadBalancersAPIClient

	options ElasticLoadBalancerDeletedWaiterOptions
}

// NewElasticLoadBalancerDeletedWaiter constructs a
// ElasticLoadBalancerDeletedWaiter.
func NewElasticLoadBalancerDeletedWaiter(client NiftyDescribeElasticLoadBalancersAPIClient, optFns ...func(*ElasticLoadBalancerDeletedWaiterOptions)) *ElasticLoadBalancerDeletedWaiter {
	options := ElasticLoadBalancerDeletedWaiterOptions{}
	options.MinDelay = 20 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = elasticLoadBalancerDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ElasticLoadBalancerDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ElasticLoadBalancerDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ElasticLoadBalancerDeletedWaiter) Wait(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ElasticLoadBalancerDeleted waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ElasticLoadBalancerDeletedWaiter) WaitForOutput(ctx context.Context, params *NiftyDescribeElasticLoadBalancersInput, maxWaitDur time.Duration, optFns ...func(*ElasticLoadBalancerDeletedWaiterOptions)) (*NiftyDescribeElasticLoadBalancersOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.NiftyDescribeElasticLoadBalancers(ctx, params, func(o *Options) {
			o.APIOptions = append(o.APIOptions, apiOptions...)
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ElasticLoadBalancerDeleted waiter")
}

func elasticLoadBalancerDeletedStateRetryable(ctx context.Context, input *NiftyDescribeElasticLoadBalancersInput, output *NiftyDescribeElasticLoadBalancersOutput, err error) (bool, error) {

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.ElasticLoadBalancer" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.Protocol.or.ElasticLoadBalancerPort" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err != nil {
		var apiErr smithy.APIError
		ok := errors.As(err, &apiErr)
		if !ok {
			return false, fmt.Errorf("expected err to be of type smithy.APIError, got %w", err)
		}

		if "Client.InvalidParameterNotFound.ElasticLoadBalancerPort" == apiErr.ErrorCode() {
			return false, nil
		}
	}

	if err == nil {
		pathValue, err := jmespath.Search("length(NiftyDescribeElasticLoadBalancersResult.ElasticLoadBalancerDescriptions[]) > `0`", output)
		if err != nil {
			return false, fmt.Errorf("error evaluating waiter state: %w", err)
		}

		expectedValue := "true"
		bv, err := strconv.ParseBool(expectedValue)
		if err != nil {
			return false, fmt.Errorf("error parsing boolean from string %w", err)
		}
		value, ok := pathValue.(bool)
		if !ok {
			return false, fmt.Errorf("waiter comparator expected bool value got %T", pathValue)
		}

		if value == bv {
			return true, nil
		}
	}

	return true, nil
}

func newServiceMetadataMiddleware_opNiftyDescribeElasticLoadBalancers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "NiftyDescribeElasticLoadBalancers",
	}
}
