// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) ImportInstanceOperation(ctx context.Context, params *ImportInstanceOperationInput, optFns ...func(*Options)) (*ImportInstanceOperationOutput, error) {
	if params == nil {
		params = &ImportInstanceOperationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ImportInstanceOperation", params, optFns, c.addOperationImportInstanceOperationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ImportInstanceOperationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ImportInstanceOperationInput struct {

	// This member is required.
	Ovf *string

	AccountingType types.AccountingTypeOfImportInstanceRequest

	Architecture *string

	Description *string

	DiskImage []types.RequestDiskImage

	InstanceId *string

	InstanceInitiatedShutdownBehavior *string

	InstanceType types.InstanceTypeOfImportInstanceRequest

	IpType types.IpTypeOfImportInstanceRequest

	Monitoring *types.RequestMonitoringOfImportInstance

	NetworkInterface []types.RequestNetworkInterface

	Placement *types.RequestPlacementOfImportInstance

	Platform *string

	PrivateIpAddress *string

	PublicIp *string

	SecurityGroup []string

	SubnetId *string

	UserData *types.RequestUserDataOfImportInstance

	noSmithyDocumentSerde
}

type ImportInstanceOperationOutput struct {
	ConversionTask *types.ConversionTask

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationImportInstanceOperationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpImportInstanceOperation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpImportInstanceOperation{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpImportInstanceOperationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opImportInstanceOperation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opImportInstanceOperation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ImportInstanceOperation",
	}
}
