// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) DescribeSslCertificateAttribute(ctx context.Context, params *DescribeSslCertificateAttributeInput, optFns ...func(*Options)) (*DescribeSslCertificateAttributeOutput, error) {
	if params == nil {
		params = &DescribeSslCertificateAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSslCertificateAttribute", params, optFns, c.addOperationDescribeSslCertificateAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSslCertificateAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSslCertificateAttributeInput struct {

	// This member is required.
	FqdnId *string

	Attribute types.AttributeOfDescribeSslCertificateAttributeRequest

	noSmithyDocumentSerde
}

type DescribeSslCertificateAttributeOutput struct {
	CaState *types.CaState

	CertAuthority *types.CertAuthority

	CertInfo *types.CertInfo

	CertState *types.CertState

	Count *types.Count

	Description *types.Description

	Fqdn *string

	FqdnId *string

	KeyLength *types.KeyLength

	Period *types.Period

	RequestId *string

	UploadState *types.UploadState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSslCertificateAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeSslCertificateAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeSslCertificateAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeSslCertificateAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSslCertificateAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeSslCertificateAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSslCertificateAttribute",
	}
}
