// Code generated by smithy-go-codegen DO NOT EDIT.

package computing

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/nifcloud/nifcloud-sdk-go/service/computing/types"
)

func (c *Client) DescribeInstanceBackupRuleActivities(ctx context.Context, params *DescribeInstanceBackupRuleActivitiesInput, optFns ...func(*Options)) (*DescribeInstanceBackupRuleActivitiesOutput, error) {
	if params == nil {
		params = &DescribeInstanceBackupRuleActivitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInstanceBackupRuleActivities", params, optFns, c.addOperationDescribeInstanceBackupRuleActivitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInstanceBackupRuleActivitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInstanceBackupRuleActivitiesInput struct {

	// This member is required.
	InstanceBackupRuleId *string

	Duration *int32

	EndDateTime *string

	MaxRecords *int32

	noSmithyDocumentSerde
}

type DescribeInstanceBackupRuleActivitiesOutput struct {
	ActivitiesSet []types.ActivitiesSet

	InstanceBackupRuleId *string

	InstanceBackupRuleName *string

	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInstanceBackupRuleActivitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeInstanceBackupRuleActivities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeInstanceBackupRuleActivities{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV2Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeInstanceBackupRuleActivitiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInstanceBackupRuleActivities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeInstanceBackupRuleActivities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInstanceBackupRuleActivities",
	}
}
